/**
 */
Ext.define('Academia.view.hrRecruitmentProcess.jobApplication.JobAppUpdateStatusWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.jobappupdatestatuswin',
	title:getCommonTranslation("UPDATE_STATUS"),
	frame: true,
	modal:true,
	method: 'POST',
	resizable:true,
	autoScroll: true,
    height: '52%',
    width: '55%',
	items: [{
		xtype:'form',
		itemId:'jobAppUpdateStatusWinFormItemId',
		plugins: "formlabelrequired",
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'hidden',
				itemId:'idItemId',
				name: 'id'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation("APPLICATION_STATUS"),
				name: 'jobApplicationStatus',
				itemId:'jobApplicationStatus',
				editable: true,
				store: 'hrRecruitmentProcess.jobApplication.jobApplicationWithoutApproveStatusStore',
				displayField:'name',
				valueField:'id',
				forceSelection:true,
				editable:false,
				typeAhead:true
				
			},{
	            xtype: 'datefield',
	            fieldLabel: getPersonModuleTranslation('DATE'),
	            name: 'date',
	            itemId :'DateId',
	            //value: new Date(),
	            listeners: {
	            	 render: function(obj) {
						 obj = dateFormatRender(obj);						
						 obj.setValue(new Date());
					 }
	            },
	            allowBlank:false
	          //--submitFormat: CONSTANTS.DATE_FORMAT
	        }]
		},{
			xtype:'fieldcontainer',
			//width: '100%',
			layout : 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
	        	xtype: 'textareafield',
				name: 'remark',
				maxLength : 100,
				itemId:'remark',
	            enforceMaxLength : true,
				fieldLabel: getHostelTranslation('REMARKS'),
				width: 536
	        }]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'savejobappupdatestatusWinItemId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
                formBind: true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text : getCommonTranslation('CANCEL'),
				itemId : 'canceljobappupdatestatusWinItemId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]	
});