/**
 */
Ext.define('Academia.view.hrRecruitmentProcess.jobApplication.UpdateJoiningStatusWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.updatejoiningstatuswin',
	title:getPlacementTranslation('PLACEMENT_JOB_APPLICATION_JOINING_STATUS'),
	frame: true,
	modal:true,
	method: 'POST',
	resizable:true,
	autoScroll: true,
    height: '52%',
    width: '55%',
	items: [{
		xtype:'form',
		itemId:'updateJoiningStatusFormItemId',
		plugins: "formlabelrequired",
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'hidden',
				itemId:'idItemId',
				name: 'id'
			},{
				xtype:'displayfield',
				name:'academyLocation',
				itemId:'academyLocationId',
				fieldLabel: getCommonTranslation("ACADEMY_LOCATION"),
			},{
				xtype:'displayfield',
				name:'jobTitle',
				itemId:'jobTitleId',
                fieldLabel: getCommonTranslation('JOB_TITLE')
			},{
				xtype:'displayfield',
				name:'designation',
				itemId:'designationId',
				fieldLabel: getPersonModuleTranslation('DESIGNATION')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel :getCommonTranslation('CONFIRMED_BY'),						
				name : 'confirmedBy',
				itemId : 'confirmedById',
				store:'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
	            valueField: 'id',
				displayField : 'value',
				allowBlank:false,
				editable:false
			},{
	            xtype: 'datefield',
	            fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN'),
	            name: 'joiningDate',
	            itemId :'joiningDateId',
	            //value: new Date(),
	            listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
	            	}
	            },
	            allowBlank:false
	          //--submitFormat: CONSTANTS.DATE_FORMAT
	        }]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			items:[{
	    		xtype: 'checkboxfield',
	    		boxLabel:getCommonTranslation('MARK_AS_ACADEMY_EMPLOYEE'),
	    		name:'chkMarkAsAcademyEmp',
	    		itemId:'chkMarkAsAcademyEmpId',
	    		inputValue: true,
				uncheckedValue: false
	    	}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'saveJoiningStatusWinItemId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
                formBind: true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text : getCommonTranslation('CANCEL'),
				itemId : 'cancelJoiningStatusWinItemId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]	
});