/*
 *@author Deepak S
 * 
 */
Ext.define('Academia.view.hrRecruitmentProcess.jobPosting.JobPostingFormLayout', {
    extend: 'Academia.view.common.IdGeneratorForm',
    alias: 'widget.jobpostingformlayout',
    //cls: 'panelNoSpace',
    formCode:'JobPostingFormLayout',
    itemId: 'jobpostingaddform',
    plugins: "formlabelrequired",
    method: 'POST',    
    standardSubmit: false,
    items: [{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		},{
			xtype :'textfield',
			name:'jobCode',
			itemId:'jobCode',
			allowBlank:false,
			fieldLabel: getCommonTranslation('JOB_CODE'),
			emptyText: getCommonTranslation('ID_AUTOGENERATE'),
		},{
			xtype:'textfield',
			name:'jobTitle',
			allowBlank:false,
			maxLength : 255,
			itemId:'jobTitleId',
			fieldLabel:getCommonTranslation("JOB_TITLE")
		}]
	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'coordinator',
			store: 'common.AllUserBySmartSearch',
			fieldLabel: getPlacementTranslation('PLACEMENT_JOB_COORDINATOR'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusId',
			store:'common.StatusComboStore',
			value:'ACTIVE',
			displayField:'name',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			allowBlank:false,
			fieldLabel:getPersonModuleTranslation('STATUS')
		}]
	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype:'nestedJsonCombo',
			fieldLabel:getCommonTranslation('ASSIGN_USER_GROUP_TYPE'),
			name:'userGroup',
			itemId : 'userGroupType',
			store: 'hrRecruitmentProcess.jobPosting.AssignUserGroupTypeStore',
			valueField: 'id',
			displayField: 'userGroupName',
			allowBlank: false,
			editable: false
		},{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('FACULTY_TYPE'),
			store : 'common.FacultyTypeCSMStore',
			valueField: 'id',
			displayField: 'value',  
			name: 'facultyType',
			itemId:'facultyTypeId',
			hidden:true,
			editable: false,
			allowBlank: false
		},{
			xtype: 'customcombobox',
			fieldLabel: getUserModuleTranslation('EMPLOYEE_TYPE'),
			store : 'user.EmployeeTypeStore',
			valueField: 'id',
			displayField: 'value',  
			name: 'employeeType',
			itemId:'employeeTypeId',
			allowBlank: false,
			editable: false,
			hidden:true
		}]
	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 468,
			labelAlign: 'top'
		},
		items: [ {
			xtype: 'textarea',
			name:'shortDescription',
			itemId:'shortDescriptionItemId',
			maxLength : 1000,
			allowBlank: true,
			fieldLabel: getExaminationTranslation('ADD_SHORT_DESC')
		}]
	
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults :{
			width: 185,
		},
		items: [{
			xtype: 'tbspacer',
			flex: 1
		},{
			xtype : 'button',
			text : getExaminationTranslation("GENERATE_JOB_DESC") ,
			itemId : 'generateJobDescBtn',
			cls : 'CustomBtnSubmitAI',
			scale : CONSTANTS.BUTTONSIZE,
			disabled: true
		},{
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonAIId',
			cls:'CustomBtnResetAI',
			scale: CONSTANTS.BUTTONSIZE
		}]
	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 468,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textarea',
			name:'jobDescription',
			maxLength : 1000,
			fieldLabel: getPlacementTranslation('JOB_DESCRIPTION'),
			grow: true
		}]
	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'datefield',
			name: 'fromDate',
			itemId:'fromDateId',
			endDateField:'toDateId',
			vtype: 'daterange',
			allowBlank: false,
			fieldLabel:getCommonTranslation('RECRUITMENT_FROM_DATE'),
			listeners: {
				render: function(obj) {
					return dateFormatRender(obj);					
				}
			}
		},{
			xtype: 'datefield',
			name: 'toDate',
			itemId:'toDateId',
			startDateField:'fromDateId',
			vtype: 'daterange',
			allowBlank: false,
			fieldLabel:getCommonTranslation('RECRUITMENT_TILL_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype : 'button',
			text : getCommonTranslation("SAVE") ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
