/**
 * @author sohan chouhan

 */
Ext.define('Academia.view.hrm.availability.HRMAvailabilityGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.hrmavailabilitygrid',
     store: 'hrm.timesheet.HRMTEmpAvailDetailsSearchStore',
    title: getCommonTranslation('EMPLOYEE_AVAILABILITY'),
    border: true,
    refreshStoreData:true,
    selType: 'checkboxmodel',
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.timesheet.HRMTEmpAvailDetailsSearchStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('HRM_EMP_ID'),
        dataIndex:'employeeCode',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex:'employeeName',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('HRM_DEPT'),
        dataIndex:'deptName',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('GENDER'),
        dataIndex:'gender',
        flex: 1,
        sortable: true
    },{
        header: getPersonModuleTranslation('DESIGNATION'),
        dataIndex:'designation',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('GROUP_TYPE'),
        dataIndex:'groupType',
        flex: 1
    }, {
        header: getCommonTranslation('EMPLOYEE_TYPE/FACULTY_TYPE'),
        dataIndex:'facultyType',
        flex: 1
    }, {
        header: getCommonTranslation('CALENDER'),
        dataIndex:'calender',
        flex: 1
    }, {
        header: getCommonTranslation('DAY'),
        dataIndex:'employeeWeekday',
        flex: 1
    }, {
        header: getCommonTranslation('FROM_AVAILABLE'),
        dataIndex:'availableFrom',
        flex: 1,
        renderer: function(record) {
        	if(!isNullOrEmpty(record)) {
        	 return timeFormatRender(record);
        	}else{
				return "";
			}
        }
    },{
    	header: getCommonTranslation('TO_AVAILABLE'),
    	dataIndex:'availableTo',
    	flex: 1,
    	renderer: function(record) {
    		if(!isNullOrEmpty(record)) {
    		return timeFormatRender(record);
    		}else{
				return "";
			}
        }
    },{
        header: getPersonModuleTranslation('REMARK'),
        dataIndex:'remark',
        flex: 1,
        hidden: true,
        renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				if(value.length > 45) {
					var splitValue = value.slice(0,45);
					metaData.tdAttr = 'data-qtip="' + Ext.String.htmlEncode(value) + '"';
					return splitValue;
				}
				else {
					return value;
				}
			}	
		}
    }]
});