/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.hrm.biometric.BMIDetailsALGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.bmidetailsalgrid',
    store: 'hrm.biometric.BMIDetailsALStore',
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.biometric.BMIDetailsALStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    title : getCommonTranslation('BMI_LIST_OF_ACADEMY_LOCATION'),
    selType:'checkboxmodel',
    selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
    tbar: [{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex: 1
    }]
});