/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.hrm.biometric.BMIFormResourceWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.bmiformresourcewin',
    title: getCommonTranslation('BMI_RESOURCE_INFORMATION'),
    frame: true,
    autoScroll: true,
    modal: true,
    method: 'POST',
    maxHeight: 500,
    width: '41%',
    //height: '46%',
    padding: '10 10 10 10',
    items: [{
		xtype: 'form',
		margin: 0,
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        items: [{
				xtype: 'hidden',
				itemId:'idResourceItemId',
				name: 'id'
			},{
				xtype: 'hidden',
				itemId:'keyCheckValItemId',
				name: 'keyCheckVal'
			},{
    			xtype : 'customcombobox',
    			name : 'academyLocation',
    			itemId:'academyLocationId',
    			fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
    			store:'user.UserAcademyLocationStore',
    			valueField : 'id',
    			displayField : 'value',
    			allowBlank : false,
    			minChars:3,
    			queryParam:'qry',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width-50;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code} / {value}' +
    					'</div>';
    				}
    			}
    		},{
				xtype:'customcombobox',
				itemId:'cmbResourceGroup',
				name:'resourceGroup',
				fieldLabel:getCommonTranslation('RESOURCE_GROUP'),
				store:'hrm.biometric.BMIResourceGroupStore',
				valueField : 'name',
				displayField : 'value',			
				editable:false,
				allowBlank:false,
				//width:'15%',
				//labelWidth: 58,
				//value:'',
				disabled:true,
				queryMode: 'local',
				//triggerAcation:'all',
				//fourceSelection:true		
			}]
	    },{
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        items: [{
				xtype:'customcombobox',
				fieldLabel:getCommonTranslation('RESOURCE_TYPE'),
				name:'resourceTypeForm',
				itemId : 'resourceTypeItemIdForm',
				store: 'hrm.biometric.BMIResourceTypeStore',
				valueField: 'id',
				displayField: 'value',
				disabled:true,
				allowBlank:false,
				editable: false
			},{
				xtype: 'multiselectcombofield',
				fieldLabel:getCommonTranslation('RESOURCE_NAME'),
				name:'resourceName',
				itemId : 'resourceNameItemIdForm',
				//store: 'hrm.biometric.BMIResourceNameByTypeStore',
				displayField:'value',
				valueField:'id',
				maxLength:15000,
				autoloadStore: false,
				allowBlank:false,
				height:'10px',
				disabled:true,
				listeners:{
					render : function(combo){
						var store=Ext.create('Academia.store.hrm.biometric.BMIResourceNameByTypeStore');
						combo.bindStore(store)
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			}]
	    },{
	    	xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'bmiResourceSubmitBtnId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'bmiResourceCancelBtnId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                cls: 'btn-with-no-icon'
            }]
        }]	
	}]
});