/**
 * @author Deepak S
 * 
 */
Ext.define('Academia.view.hrm.report.BMStudentPunchLogReportFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.bmstudentpunchlogreportfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('FROM_DATE'),
            name: 'fromDate',
            itemId: 'fromDateItemId',
            endDateField: 'toDateItemId',
            format: CONSTANTS.DATE_FORMAT,
            allowBlank: false,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            editable:false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('To_Date'),
            name: 'toDate',
            itemId: 'toDateItemId',
            startDateField: 'fromDateItemId',
            format: CONSTANTS.DATE_FORMAT,
            allowBlank: false,
            editable:false,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'customcombobox',
			name: 'STUDENT_ID',
			itemId:'studentId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'feeandpayment.managebill.Student',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype: 'customcombobox',
			name:'PROGRAM_ID',
			store: 'program.ProgramByGroupIdStore',
			itemId:'program',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'qry',
			minChars:3,
			allowBlank: true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'BATCH_ID',
			itemId: 'batch',
			disabled:true,
			fieldLabel: getPersonModuleTranslation('BATCH'),
			editable: false,
			queryMode: 'local',
			displayField: 'value',
			valueField: 'id',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
					combo.bindStore(store);
				}
			}
		}]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchStudentPunchLogReportFilterItemId',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true,
            margin: '0 44 0 0'
        }, {
            xtype: 'button',
            itemId: 'resetStudentPunchLogReportFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});