/**
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.hrm.timesheet.HRMEmployeeTimesheetSummaryGrid', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.hrmemployeetimesheetsummarygrid',
    // store: 'hrm.timesheet.HRMEmployeeDetailedTimesheetGrid',
    title: getPersonModuleTranslation('HRM_EMPLOYEE_TIMESHEET_SUMMARY'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   
    columns: [{
        header: getPersonModuleTranslation('HRM_TIMESHEET_PAY_DAYS'),
        dataIndex: 'timeSheetDays',
        flex: 1
    },{
        header: getPersonModuleTranslation('Total Working Days'),
        dataIndex: 'totalWorkingDays',
        flex: 1
    },{
        header: getPersonModuleTranslation('HRM_TOTAL_PRESENTS'),
        dataIndex: 'totalPresent',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_ABSENTS'),
        dataIndex: 'totalAbsent',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_LEAVES'),
        dataIndex: 'totalLeaves',
        flex: 1
    },{
    	header: getPersonModuleTranslation('Compensatory Leaves'),
    	dataIndex: 'totalCompensatoryLeave',
    	flex: 1,
    	sortable: false
    },{
        header: getPersonModuleTranslation('LOP'),
        dataIndex: 'totalLOP',
        flex: 1,
        sortable: false
    },{
        header: getPersonModuleTranslation('Others'),
        dataIndex: 'markingTypeStatusCount',
        flex: 1,
        sortable: false
    },/*{
        header: getPersonModuleTranslation('HRM_OFF_HOLIDAYS'),
        dataIndex: 'offholidays',
        flex: 1,
        renderer: function(value, metadata, record) {
            var msg = "";
            if (!isNullOrEmpty(record.data.totalHolidays) || !isNullOrEmpty(record.data.totalWeeklyOffs)){
            	msg = record.data.totalHolidays + record.data.totalWeeklyOffs;
            	 return msg;
            	}
            return msg;
        }
    },*/ {
        header: getPersonModuleTranslation('HRM_LESS_WORKING_HOUR'),
        dataIndex: 'totalLessWorkingHours',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_ATTENDANCE_PERCENT'),
        dataIndex: 'attendancePercentage',
        flex: 1,
        renderer : function(attendancePercentage) {
        	if(Number.isInteger(attendancePercentage)) {
        		return (attendancePercentage + '%');	
        	}else {
        		var attendancePercentage =  Ext.util.Format.number(attendancePercentage, '0.00');
            	return (attendancePercentage + '%');
        	}
        }
    }
],
});