/**
 * @author Deepak Sharma
 * This component is used for Transport -> Vehicle Type Grid
 */
Ext.define('Academia.view.hrm.timesheet.HRMTimesheetPeriodGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.hrmtimesheetperiodgrid',
    store : 'hrm.timesheet.HRMTimesheetPeriodGridStore',
    border: true,
	//autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    title: getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'),
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'hrmtimesheetperiodstructure':1
		}
	},
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hrm.timesheet.HRMTimesheetPeriodGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'

    },{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH

    }],
    columns: [{
        header: getCommonTranslation('TIME_SHEET_NAME'),
        dataIndex: 'name',
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('START_DATE'),
        dataIndex: 'startDate',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return dateRender(value);
            } else {
                return "-";
            }
        }
    }, {
        header: getCommonTranslation('TILL_DATE'),
        dataIndex: 'endDate',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return dateRender(value);
            } else {
                return "-";
            }
        }
    }]
});