/**
 *  @author Niklesh Tiwane
 */
Ext.define('Academia.view.importutility.ImportByModule.ImportListAlumni', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.importlistalumni',
	store : 'importutility.ImportApplicantStore',
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'importutility.ImportApplicantStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		text: getAlumni('IMPORT_DATA'),
		itemId: 'btnAdd',
		tooltip: getAlumni('IMPORT_DATA'),
		glyph: ICONGLYPH.ADDGLYPH,
		hidden:true
	},{
		xtype: 'button',
		text: getAlumni('DOWNLOAD_TEMPLATE'),
		itemId: 'btnDownloadTemp',
		tooltip: getAlumni('DOWNLOAD_TEMPLATE'),
		glyph: ICONGLYPH.ADDGLYPH,
		hidden:true
	},{
		xtype: 'button',
		text: getAlumni("REFRESH"),
		itemId: 'btnRefresh',
		tooltip: 'Refresh',
		handler: function(){
			var myGridStore = this.ownerCt.ownerCt.getStore();
			myGridStore.getProxy().extraParams = {
				moduleName: "Import Bulk Alumni"
			};
			myGridStore.load();
		}
	},{
		xtype: 'button',
		text: getAlumni('IMPORT_UTILITY_FORCE_RUN'),
		itemId: 'btnForce',
		tooltip: 'Force run job',
	}],
	columns: [{
		header : getAlumni('MODULE_NAME'),
		dataIndex : 'importUtilityMaster',
		flex : 1,
		renderer:function(obj){
			if(obj.value){
				return  obj.value;
			}
		}
	},{
		header : getAlumni('UPLOADED_FILE_NAME'),
		dataIndex : 'originalFileName',
		flex : 1,
		renderer:function(value){
			if(value){
				return  '<a href="#">'+value+'</a>';
			}
		}	
	},{
		header : getAlumni('UPLOADED_BY'),
		dataIndex : 'uploadedBy',
		flex : 1,
		renderer:function(obj){
			if(obj.value){
				return  obj.value;
			}
		}
	},{
		header : getAlumni('UPLOADED_ON'),
		dataIndex : 'importedOn',
		flex : 1,
		renderer: function(val){
			var mergedDate = dateRender(val)+' '+timeRender(val);
			return mergedDate;
		}
	},{
		header : getAlumni('PROCESSING_STATUS'),
		dataIndex : 'status',
		flex : 1
	},{
		header : getAlumni('PROCESSED_ON'),
		dataIndex : 'processedOn',
		flex : 1,
		renderer: function(val){
			var mergedDate = dateRender(val)+' '+timeRender(val);
			return mergedDate;
		}
	},{
		header : getAlumni('FAILURE_FILE'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if(value == 'Partially Processed'){
				return  '<a href="#">'+getCommonTranslation('DOWNLOAD')+'</a>';
			}
		}
	},{
		header : getAlumni('IMPORT_LOG_FILE'),
		dataIndex : 'whetherRecordFail',
		flex : 1,
		renderer:function(value){
			if(value){
				return  '<a href="#">'+getAlumni('DOWNLOAD')+'</a>';
			}
		}
	}]
});
