/**
 *  @author Angad.Yadav
 */
Ext.define('Academia.view.importutility.ImportByModule.UploadListExtendedTimeTable', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.uploadListExtendedTimeTable',
	store : 'importutility.UploadExtendedTimeTable',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'importutility.UploadExtendedTimeTable',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
    	 xtype: 'button',
    	 text: getCommonTranslation('IMPORT_DATA'),
         itemId: 'btnAdd',
         tooltip: getCommonTranslation('IMPORT_DATA'),
         glyph: ICONGLYPH.ADDGLYPH,
         hidden:true
    },{
	   	 xtype: 'button',
		 text: getCommonTranslation('DOWNLOAD_TEMPLATE'),
	     itemId: 'btnDownloadTemp',
	     tooltip: getCommonTranslation('DOWNLOAD_TEMPLATE'),
	     glyph: ICONGLYPH.ADDGLYPH,
	     hidden:true
	},{
		 xtype: 'button',
		 text: getProgramandcourseTranslation('REFRESH'),
	     itemId: 'btnRefresh',
	     tooltip: 'Refresh',
	     handler: function(){
	    	 var me = this;
	    	 var myGridStore = me.ownerCt.ownerCt.getStore();
	    	 myGridStore.load({
	    		    callback: function(records, operation, success) {
	    		        if (success) {
	    		            myGridStore.filterBy(function(record) {
	    		                var utility = record.get('importUtilityMaster');
	    		                return utility && utility.value === 'Bulk Extended Time Table';
	    		            });
	    		            myGridStore.totalCount = myGridStore.getCount();
	    		            var toolbar = me.ownerCt.up('uploadListExtendedTimeTable').down('custompagingtoolbar');
	    		            if (toolbar) {
	    		            	toolbar.onLoad(); // refresh display info
	    		            }
	    		        }
	    		    }
	    		});
	     }
	},{
		 xtype: 'button',
		 text: getCommonTranslation('IMPORT_UTILITY_FORCE_RUN'),
	     itemId: 'btnForce',
	     tooltip: 'Force run job',
	}],
	columns: [{
	        	header : getCommonTranslation('MODULE_NAME'),
	     		dataIndex : 'importUtilityMaster',
	     		flex : 1,
	     		renderer:function(obj){
	     			if(obj.value){
					    return  obj.value;
		     		 }
	     		}
	         },{
	        	 header : getCommonTranslation('UPLOADED_FILE_NAME'),
		     	 dataIndex : 'originalFileName',
		     	 flex : 1,
		     	 renderer:function(value){
		     		 if(value){
					    return  '<a href="#">'+value+'</a>';
		     		 }
				}	
	         },{
	        	 header : getCommonTranslation('UPLOADED_BY'),
		     	 dataIndex : 'uploadedBy',
		     	 flex : 1,
		     	 renderer:function(obj){
		     		if(obj.value){
		     			return  obj.value;
		     		}
		     	 }
	         },{
	        	 header : getCommonTranslation('UPLOADED_ON'),
		     	 dataIndex : 'importedOn',
		     	 flex : 1,
		     	 renderer: function(val){
		     		 var mergedDate = dateRender(val)+' '+timeRender(val);
		     		 return mergedDate;
		     	 }
	         },{
	        	 header : getCommonTranslation('PROCESSING_STATUS'),
		     	 dataIndex : 'status',
		     	 flex : 1
	         },{
	        	 header : getCommonTranslation('PROCESSED_ON'),
		     	 dataIndex : 'processedOn',
		     	 flex : 1,
		     	 renderer: function(val){
		     		var mergedDate = dateRender(val)+' '+timeRender(val);
		     		return mergedDate;
		     	 }
	         },{
	        	 header : getCommonTranslation('FAILURE_FILE'),
		     	 dataIndex : 'whetherRecordFail',
		     	 flex : 1,
		     	 renderer:function(value){
		     		 if(value){
					    return  '<a href="#">'+getCommonTranslation('DOWNLOAD')+'</a>';
		     		 }
		     	 }
	         },{
	        	 header : getCommonTranslation('IMPORT_LOG_FILE'),
		     	 dataIndex : 'whetherRecordFail',
		     	 flex : 1,
		     	 renderer:function(value){
		     		 if(value){
					    return  '<a href="#">'+getCommonTranslation('DOWNLOAD')+'</a>';
		     		 }
				}
	         }]
});
