/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMEmployeeLeaveCancellationRequestDetailForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.lmemployeeleavecancellationrequestdetailform',
    method: 'POST',
    //modal: true,
    //width: '100%',
    height:'100%',
    plugins: "formlabelrequired",
    autoScroll: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
    			xtype: 'hidden',
    			itemId:'leaveRequestItemId',
    			name: 'leaveRequestId'
    		},{
                xtype: 'datefield',
                name: 'lmFromDateId',
                itemId: 'lmFromDateId',
                editable: false,
                readOnly:true,
                fieldLabel: getPersonModuleTranslation('LM_LEAVE_FROM_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            },
            {
                xtype: 'datefield',
                name: 'lmToDateId',
                itemId: 'lmToDateId',
                editable: false,
                readOnly:true,
                fieldLabel: getPersonModuleTranslation('LM_LEAVE_TO_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            }]
        },{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'datefield',
                name: 'lmCancelFromDateId',
                itemId: 'lmCancelFromDateId',
                editable: false,
                allowBlank: false,
                fieldLabel: getPersonModuleTranslation('LM_LEAVE_CANCEL_FROM_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
                endDateField : 'lmCancelToDateId',
                vtype : 'daterange'
            },{
                xtype: 'datefield',
                name: 'lmCancelToDateId',
                itemId: 'lmCancelToDateId',
                editable: false,
                allowBlank: false,
                fieldLabel: getPersonModuleTranslation('LM_LEAVE_CANCEL_TO_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
                startDateField : 'lmCancelFromDateId',
                vtype : 'daterange'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 536,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'textarea',
                name: 'leaveCancellationId',
                itemId: 'leaveCancellationId',
                allowBlank: false,
                width: 536,
                maxLength: 250,
                fieldLabel: getPersonModuleTranslation('LMAS_LEAVE_CANCELLATION_REASON')
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveEmployeeLeaveCancellationForm',
                text: getCommonTranslation('SAVE'), //Save
                ui: 'CustomBtnSubmit',
                formBind: true,
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                text: getExaminationTranslation('RESET'),
                itemId: 'btnResetEmployeeLeaveCancellationForm',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                /*handler: function() {
                    this.up('form').getForm().reset();
                }*/
            }]
        }]
});