/**
 * 
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMEmployeeLeaveRequestDetailWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.lmemployeeleaverequestdetailwin',
    title: getCommonTranslation('LM_REQUEST_TIMELINE'),
    modal: true,
    resizable: true,
    autoScroll: true,
    height : '50%',
    maxHeight: '65%',
	width: '60%',
	//frame: true,
    items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		height:'30px',
		items: [{
			xtype: 'displayfield',
			id: 'empReqDetailWinApprovalFlowId',
			itemId: 'approvalFlowItemId',
			name: 'empReqDetailWinApprovalFlowId',
			fieldLabel: getCommonTranslation('LM_APPROVAL_FLOW'),
			labelAlign: 'left',
			width: 256,
			labelWidth: 90
		}]
	},{
        xtype: 'grid',
        store: 'leavemanagement.leaveapprovalsetup.LMLeaveRequestDetailStore',
        frame: false,
        border: true,
        autoScroll: false,
        itemId: 'lmEmployeeLeaveRequestDetailGrid',
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        style: {
        	margin: '8px 0px'
        },
        columns: [{
            header: getCommonTranslation('LM_LEVEL'),
            dataIndex: 'approverLevelId',
            flex: 1,
        },{
            header: getCommonTranslation('LM_APPROVER'),
            dataIndex: 'reqApprover',
            flex: 1,
            renderer: function(value) {
                if (!isNullOrEmpty(value)) {
                    return value.value;
                } else {
                    return "-";
                }
            }
        },{
            header: getCommonTranslation('LM_COMMENTS'),
            dataIndex: 'comment',
            flex: 1,
        },{
            header: getCommonTranslation('LM_REQUEST_RECIEVED_DATE'),
            dataIndex: 'requestReceivedDate',
            flex: 1,
            renderer: function(value) {
                if (!isNullOrEmpty(value)) {
                    return dateRender(value);
                } else {
                    return "";
                }
            }
        },{
            header: getCommonTranslation('LM_UPDATED_ON'),
            dataIndex: 'actionDate',
            flex: 1,
            renderer: function(value) {
                if (!isNullOrEmpty(value)) {
                    return dateRender(value);
                } else {
                    return "";
                }
            }
        },{
            header: getCommonTranslation('LM_ACTION'),
            dataIndex: 'status',
            flex: 1,
            renderer: function(value) {
            	if(value == 'PENDING') {
            		return getCommonTranslation('PENDING')
            	}else if (value == 'APPROVED') {
            		return getCommonTranslation('APPROVED')
            	}else if (value == 'REJECT') {
            		return getCommonTranslation('REJECTED')
            	}else if (value == 'WITHDRAWN') {
            		return getCommonTranslation('WITHDRAWN')
            	}else if (value == 'ESCALATED') {
            		return getCommonTranslation('ESCALATED')
            	}
            	return value;
            }
        }]
    }]
});