/**
 * Shashank Jain
 */
var statusStore = Ext.create('Ext.data.Store', {
    fields: ['name', 'value'],
    data : [
        {"name":"APPROVED", "value":"Approved"},
        {"name":"REJECTED", "value":"Rejected"},
    ]
});
Ext.define('Academia.view.leavemanagement.approvalsetup.LMRequestActionHistoryFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.lmrequestactionhistoryfilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
        	labelAlign: 'top',
        	width: 256
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('FROM_DATE'),
            itemId: 'fromDateActionHistoryItemId',
            name: 'fromDateActionHistoryId',
            forceSelection: true,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            },
            endDateField: 'toDateActionHistoryItemId',
            vtype: 'daterange'

        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('To_Date'),
            itemId: 'toDateActionHistoryItemId',
            name: 'toDateActionHistoryId',
            forceSelection: true,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            },
            startDateField: 'fromDateActionHistoryItemId',
            vtype: 'daterange'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
        	labelAlign: 'top',
        	width: 256
        },
        items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('REQUESTER_NAME_OR_ID'),
                name: 'requesterNameOrIdActionHistory',
                itemId: 'requesterNameOrIdActionHistoryItemId',
                store: 'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
                valueField: 'id',
                displayField: 'valueCode',
                forceSelection: true,
                queryParam: 'codeOrName',
                minChars: 3,
                typeAhead: false,
                triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                enableKeyEvents: 'true',
                hideTrigger: false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                triggerAction: '',
                forceSelection: true,
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
            },
            {
            	xtype: 'customcombobox',
            	name: 'lmConfigStatusActionHistory',
            	itemId: 'lmConfigStatusActionHistory',
            	store: statusStore,
            	fieldLabel: getPersonModuleTranslation('STATUS'),
            	valueField: 'name',
            	displayField: 'value',
            	editable: false,
            	}
        ]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchRPAFilterActionHistoryItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            //formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetRPAFilterActionHistoryItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]

    }]
});