/**
 * @author Ankur Jaiswal
 * 
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.downloadupload.EmployeeLeaveBalanceUpdateDownloadForm',{
	extend : 'Ext.form.Panel',
	alias : 'widget.employeeleavebalanceupdatedownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	width:'auto',
	height:'auto',
	items : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
			name: 'lmAcademyLocationComboAS',
			itemId: 'lmAcademyLocationComboAS',
			editable: false,
			store: 'user.UserAcademyLocationStore',
			displayField: 'value',
			valueField: 'id',
			allowBlank: false,
			queryParam: 'nameOrCode',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
            xtype: 'customcombobox',
            itemId: 'empItemId',
            store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
			name: 'empId',
            fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
            queryParam:'name',
			displayField: 'valueCode',
			valueField: 'id',
			minChars: 3,
			typeAhead: false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents: 'true',
			hideTrigger: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
            xtype: 'customcombobox',
            name: 'userGroupId',
            itemId: 'userType',
            store: 'userGroup.UserGroupStore',
            fieldLabel: getCommonTranslation('USER_GROUP_TYPE'),
            valueField: 'id',
            displayField: 'userGroupName',
            typeAhead: false,
            editable: false,
            queryMode : 'local'
        }]
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items: [{
            xtype: 'customcombobox',
            itemId: 'lmDepartmentAS',
            fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
            displayField:'value',
            valueField:'id',
            name: 'lmDepartment',
            editable: false,
            triggerAcation: 'all',
            fourceSelection: true,
            store: 'department.DepartmentAcademyLocationWiseStore',
            allowBlank: true
        },{
    		xtype: 'customcombobox',
    		itemId:'lmDesignationItemId',
    		fieldLabel: getPersonModuleTranslation('DESIGNATION'),
    		store: 'common.DesignationTypeStore',
    		valueField: 'id',
    		displayField: 'value',        
    		name : 'designationId',
    		editable: false,
    		triggerAcation: 'all',
    		fourceSelection: true
    	},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('GENDER'), //Gender
			name: 'gender',
			itemId: 'lmGenderAS',
			valueField: 'id',
			displayField: 'value',
			store: 'common.GenderTypeStore',
			editable: false
		}]
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN_FROM'),
            name: 'dateOfJoiningFrom',
            itemId: 'fromDateItemId',
            format: CONSTANTS.DATE_FORMAT,
            endDateField: 'toDateItemId',
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN_TO'),
            name: 'dateOfJoiningTO',
            itemId: 'toDateItemId',
            format: CONSTANTS.DATE_FORMAT,
            startDateField: 'fromDateItemId',
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },{
        	xtype: 'customcombobox',
        	itemId:'employeeStatusId',
        	fieldLabel: getPersonModuleTranslation('EMPLOYEE_STATUS'),
        	store:Ext.create('Academia.store.common.StatusComboStore'),
        	displayField: 'name',
        	valueField: 'value',   
        	name : 'employeeStatus',
        	editable: false,
        	triggerAcation: 'all',
        	fourceSelection: true
        }]
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items:[{
			xtype: 'button',
			text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
			itemId: 'downoladBtnIdAS',
			//hidden:false,
			//formBind: true,
			ui: 'CustomBtnSubmit'
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtnAS',
			//buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
