/**
 * @author deepak S
 */
Ext.define('Academia.view.leavemanagement.leavecreditsetting.LeaveCreditSettingFilterForm', {
	extend: 'Ext.form.Panel',
    alias: 'widget.leavecreditsettingfilterform',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins:"formlabelrequired",
    cls:'customSearchPanel',
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'customcombobox',
            name: 'creditSettingCode',
            itemId:'creditSettingCodeItemId',
            store:'leavemanagement.leavecreditsetting.LeaveCreditSettingCodeFilterStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('HR_CREDIT_SETTING_CODE'),
        },{
        	xtype: 'customcombobox',
            name: 'HRLeaveType',
            itemId:'HRLeaveTypeItemId',
            store:'leavemanagement.LeaveTypeStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('LEAVE_TYPE'),
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'filterSearchId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        },{
        	xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});