/*
 *@author Deepak S
 * 
 */
Ext.define('Academia.view.leavemanagement.leavecreditsetting.LeaveCreditSettingFormLayout', {
	extend:'Academia.view.common.DynamicFieldForm',
    alias: 'widget.leavecreditsettingformlayout',
    bodyPadding:'10 10 10 10',
    formCode:'LeaveCreditSettingFormLayout',
    autoScroll: false,
    frame: true,
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    layout: {
        type: 'vbox'
    },
    itemId: 'leavecreditsettingform',
    title: getCommonTranslation('ADD_LEAVE_CREDIT_SETTINGS'),
    plugins: "formlabelrequired",
    method: 'POST',    
    standardSubmit: false,
    cls:'x-form-fixed-footer-parent',
    items: [{
    	xtype : 'fieldcontainer',
    	width : '100%',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		labelAlign : 'top'
    	},
    	items : [{
    		xtype: 'multiselectcombofield',
    		name: 'hrLeaveCreditSettingLocations',
    		itemId: 'academyLocationId',
    		fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
    		autoloadStore: false,
    		width: 536,
    		height: 'auto',
    		store : Ext.create('Academia.store.facilitiesresources.resourcebooking.AcademyLocationListByUserStore'),
    		cls:'multiBrandCampusCls',
    		displayField : 'value',
    		valueField : 'id',
    		allowBlank : false,
    		queryParam:'nameOrCode',
    		minChars:3,
    		typeAhead:true,
    		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    		enableKeyEvents  : 'true',
    		hideTrigger:false,
    		forceSelection:true,
    		listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{code}' +
    				'</div>';
    			}
    		}
    	}]
    },{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'textfield',
			name : 'code',
			itemId:'creditSettingCodeId',
			fieldLabel : getCommonTranslation("HR_CREDIT_SETTING_CODE"),
			allowBlank:false,
			editable: false,
			maxLength: 60
		},{
			xtype: 'customcombobox',
			name: 'hrLeaveType',
			itemId: 'leaveTypeId',
			fieldLabel: getCommonTranslation('LEAVE_TYPE'),
			store:'leavemanagement.LeaveTypeStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true,
			//emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name: 'year',
			itemId: 'yearId',
			fieldLabel: getCommonTranslation('YEAR'),
			store:'leavemanagement.leavecreditsetting.LeaveYearStore',
			valueField: 'value',
			displayField: 'value',
			editable: false,
			disabled:true,
			forceSelection: true,
			//emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name: 'monthStartsFrom',
			itemId: 'monthId',
			fieldLabel: getCommonTranslation('MONTH'),
			store:'feeandpayment.SkipMonths',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			disabled:true,
			forceSelection: true,
			//emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'hrLeaveCreditType',
			itemId: 'creditTypeId',
			fieldLabel: getCommonTranslation('HR_CREDIT_TYPE'),
			store: 'leavemanagement.leavecreditsetting.LeaveCreditTypeEnumStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true,
			allowBlank: false
		}, {
			xtype: 'customcombobox',
			name: 'leaveCreditPeriod',
			itemId: 'creditPeriodId',
			fieldLabel: getCommonTranslation('CREDIT_PERIOD'),
			store: 'leavemanagement.leavecreditsetting.LeaveCreditPeriodEnumStore',
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			//emptyText: getCommonTranslation('SELECT'),
			editable: false,
			forceSelection: true,
			allowBlank: false
		},{
			xtype      : 'radiogroup',
			fieldLabel : getCommonTranslation('HR_PRORATED_CREDIT'),
			itemId: 'proratedCreditId',
			disabled:true,
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items:[{ 
				boxLabel: getCommonTranslation('YES'), 
				name: 'isproratedCreditId', 
				inputValue: true,
			},{ 
				boxLabel: getCommonTranslation('NO'), 
				name: 'isproratedCreditId', 
				inputValue: false,
				checked:true
			}]
		},{
			xtype: 'checkboxfield',
			name: 'creditFromNextPeriodOfJoining',
			width: 'auto',
			style: 'margin-top: 25px',
			labelAlign: 'right',
			itemId:'creditFromNextPeriodOfJoiningId',
			boxLabel: getCommonTranslation('HR_CREDIT_FROM_NEXT_PERIOD_OF_JOINING'),
			disabled:true,
			inputValue : true
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'numberfield',
			name: 'creditBalance',
			itemId: 'creditBalanceId',
			disabled:true,
			fieldLabel: getCommonTranslation('HR_CREDIT_BALANCE'),
			allowBlank: false,
			hideTrigger: false,
			mouseWheelEnabled:false,
			maxLength: 5,
			//enforceMaxLength : true,
			minValue:0,
			keyNavEnabled: false,
			allowExponential: false,
			allowDecimals: true,
			decimalPrecision:2
		},{
			xtype: 'numberfield',
			name: 'maxCreditBalance',
			itemId: 'maxBalanceId',
			disabled:true,
			fieldLabel: getCommonTranslation('HR_MAX_BALANCE'),
			hideTrigger: false,
			mouseWheelEnabled:false,
			maxLength: 5,
			allowBlank: false,
			//enforceMaxLength : true,
			minValue:0,
			keyNavEnabled: false,
			allowExponential: false,
			allowDecimals: true,
			decimalPrecision:2
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype      : 'radiogroup',
			fieldLabel : getCommonTranslation('HR_LEAVE_LAPSE'),
			itemId: 'leaveLapseId',
			disabled:true,
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items:[{ 
				boxLabel: getCommonTranslation('YES'), 
				name: 'isleaveLapseId', 
				inputValue: true,
			},{ 
				boxLabel: getCommonTranslation('NO'), 
				name: 'isleaveLapseId', 
				inputValue: false,
				checked:true
			}]
		},{
			xtype: 'customcombobox',
			name: 'leaveLapsePeriod',
			itemId: 'lapsePeriodId',
			disabled:true,
			fieldLabel: getCommonTranslation('HR_LAPSE_PERIOD'),
			store: 'leavemanagement.leavecreditsetting.LeaveCreditPeriodEnumStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true,
			allowBlank: false
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype      : 'radiogroup',
			fieldLabel : getCommonTranslation('HR_LEAVE_ENCASHMENT'),
			itemId: 'leaveEncashmentId',
			disabled:true,
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items:[{ 
				boxLabel: getCommonTranslation('YES'), 
				name: 'isleaveEncashmentId', 
				inputValue: true
			},{ 
				boxLabel: getCommonTranslation('NO'), 
				name: 'isleaveEncashmentId', 
				inputValue: false,
				checked:true
			}]
		},{
			xtype: 'customcombobox',
			name: 'leaveEncashmentPeriod',
			itemId: 'encashmentPeriodId',
			fieldLabel: getCommonTranslation('HR_ENCASHMENT_PERIOD'),
			store: 'leavemanagement.leavecreditsetting.LeaveCreditPeriodEnumStore',
			valueField: 'id',
			disabled:true,
			displayField: 'value',
			editable: false,
			forceSelection: true,
			//emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		},{
			xtype: 'numberfield',
			name: 'minBalanceForLeaveEncashment',
			itemId: 'minBalanceRequiredId',
			fieldLabel: getCommonTranslation('HR_MIN_BALANCE_REQUIRED'),
			hideTrigger: false,
			mouseWheelEnabled:false,
			disabled:true,
			maxLength: 5,
			//enforceMaxLength : true,
			minValue:0,
			keyNavEnabled: false,
			allowExponential: false,
			allowDecimals: true,
			decimalPrecision:1,
			allowBlank: false
		},{
			xtype: 'numberfield',
			name: 'maxDaysForLeaveEncashment',
			itemId: 'maxDaysToEncashId',
			fieldLabel: getCommonTranslation('HR_MAX_DAYS_TO_ENCASH'),
			hideTrigger: false,
			mouseWheelEnabled:false,
			maxLength: 5,
			disabled:true,
			//enforceMaxLength : true,
			minValue:0,
			keyNavEnabled: false,
			allowExponential: false,
			allowDecimals: true,
			decimalPrecision:1,
			allowBlank: false
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype      : 'radiogroup',
			fieldLabel : getCommonTranslation('HR_LEAVE_CARRY_FORWARD'),
			itemId: 'leaveCarryForwardId',
			disabled:true,
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items:[{ 
				boxLabel: getCommonTranslation('YES'), 
				name: 'isleaveCarryForwardId', 
				inputValue: true
			},{ 
				boxLabel: getCommonTranslation('NO'), 
				name: 'isleaveCarryForwardId', 
				inputValue: false,
				checked:true
			}]
		},{
			xtype: 'customcombobox',
			name: 'leaveCarryForwardPeriod',
			itemId: 'carryForwardPeriodId',
			fieldLabel: getCommonTranslation('HR_CARRY_FORWARD_PERIOD'),
			store: 'leavemanagement.leavecreditsetting.LeaveCreditPeriodEnumStore',
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			editable: false,
			forceSelection: true,
			//emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		},{
			xtype: 'numberfield',
			name: 'maxDaysToCarryForward',
			itemId: 'maxDaysToCarryForwardId',
			fieldLabel: getCommonTranslation('HR_MAXDAYS_TO_CARRY_FORWARD'),
			hideTrigger: false,
			mouseWheelEnabled:false,
			maxLength: 5,
			//enforceMaxLength : true,
			minValue:0,
			keyNavEnabled: false,
			allowExponential: false,
			disabled:true,
			allowDecimals: true,
			decimalPrecision:1,
			allowBlank: false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'textfield',
			name : 'elgibilityBasedOn',
			itemId:'eligibilityBasedOnId',
			fieldLabel : getCommonTranslation("ELIGIBILITY_BASED_ON"),
			readOnly:true,
			editable: false
		},{
			xtype: 'customcombobox',
			name: 'hrEmployeeAttributeType',
			itemId: 'employeeAttributeTypeId',
			fieldLabel: getCommonTranslation('EMPLOYEE_ATTRIBUTE_TYPE'),
			store: 'leavemanagement.leavecreditsetting.EmployeeAttributeTypeEnumStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true,
			hidden:true,
			disabled:true,
			//emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		},{
			xtype: 'multiselectcombofield',
			name: 'empAttributeValue',
			itemId:'empAttributeValueItemId',
			store:'department.DepartmentAcademyLocationWiseStore',
			displayField:'value',
			hidden:true,
			valueField:'id',
			cls:'multiBrandCampusCls',
			allowBlank:true,
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('ATTRIBUTE_VALUE'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
        },{
        	xtype: 'multiselectcombofield',
            name: 'enumEmpAttributeValue',
            itemId:'enumEmpAttributeValueItemId',
            store:'common.GenderTypeStore',
            displayField:'value',
            valueField:'id',
            hidden:true,
            forceSelection:true,
            cls:'multiBrandCampusCls',
            editable:false,
            allowBlank:true,
            typeAhead:true,
            fieldLabel:getCommonTranslation('ATTRIBUTE_VALUE'),
            listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
        },{
        	xtype: 'multiselectcombofield',
            name: 'userGrpEmpAttributeValue',
            itemId:'userGrpEmpAttributeValueItemId',
            store: 'leavemanagement.EmpLeaveUserGroupAttributeValue',
            displayField:'valueTranslation',
            valueField:'code',
            hidden:true,
			autoloadStore: false,
			cls:'multiBrandCampusCls',
            allowBlank:true,
            fieldLabel:getCommonTranslation('ATTRIBUTE_VALUE'),
            listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
        },{
			xtype: 'multiselectcombofield',
			name: 'designationAttributeValue',
			itemId:'designationAttributeValueItemId',
			store:'personinfo.common.pasthistory.WorkExperienceDesignationStore',
			displayField:'value',
			hidden:true,
			valueField:'id',
			cls:'multiBrandCampusCls',
			allowBlank:true,
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('ATTRIBUTE_VALUE'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
        },{
			xtype: 'customcombobox',
			name: 'leaveSetupEmpTypeChanged',
			itemId: 'leaveSetupEmpTypeChanged',
			fieldLabel: getCommonTranslation('LEAVE_SETUP_IF_EMPLOYEE_TYPE_CHANGED'),
			store: 'leavemanagement.leavecreditsetting.LeaveSetupIfEmpTypeChangedStore',
			valueField: 'value',
			displayField: 'name',
			editable: false,
			width:247,
			forceSelection: true,
			hidden:true,
			disabled:true,
		}]
	}, {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	cls:'form-fixed-footer',
    	items: [{
    		xtype: 'button',
    		itemId: 'btnSaveLeaveCreditSettingForm',
    		text: getCommonTranslation('SAVE'), //Save
    		ui: 'CustomBtnSubmit',
    		formBind: true,
    		scale: CONSTANTS.BUTTONSIZE
    	},{
    		xtype: 'button',
    		text: getExaminationTranslation('RESET'),
    		itemId: 'btnResetLeaveCreditSettingForm',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]
});
