/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.leavemanagement.leavegeneralsetting.LeaveHolidayCheckGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.leaveholidaycheckgrid',
    store: 'leavemanagement.leavegeneralsetting.LeaveHolidayCheckStore',
    title: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_ENTRY_TABLE'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		hidden: true,
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_SERIAL_NO'),
        dataIndex: 'serialNo',
        flex: 0.44,
        sortable: true
    }, {
    	header: getPersonModuleTranslation('LMAS_LEAVE_TYPE'),
    	dataIndex: 'leaveType',
    	flex: 0.6,
    	sortable: true,
    	editor: {
    		xtype: 'customcombobox',
    		name: 'leaveType',
    		itemId: 'leaveTypeItemId',
    		valueField: 'id',
    		store:Ext.create('Academia.store.leavemanagement.leavegeneralsetting.LeaveTypeGeneralSettingStore'),
    		displayField:'value',
    		forceSelection: true,
    		editable: false,
    		listeners: {
    			blur: function(combo, r) {
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: null
    					};
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				var me = this.up('leaveholidaycheckgrid');
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: me.getAllSelectedLeaveTypeIds(combo)
    					};
    				});
    				combo.getStore().load();
    			}
    		}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(record.get('leaveTypeName')){
						return record.get('leaveTypeName')
					}else if(index !== -1){
    					record.data.leaveTypeName = rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('leaveTypeName');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('leaveType')) && isNullOrEmpty(record.get('leaveType'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
    }, {
        header: getPersonModuleTranslation('LEAVE_HOLIDAY_CHECK_GENERAL_SETTING'),
        dataIndex: 'holidayCheck',
        flex: 0.45,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'holidayCheck',
            itemId: 'holidayCheckId',
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            store:Ext.create('Academia.store.leavemanagement.leavegeneralsetting.LeaveHolidayCheckComboStore'),
            editable: false,
            listeners: {
                blur: function(combo, r) {
                    combo.setValue(combo.getValue());
                }
            }
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					}
				}
				catch(e){
					return null;
				}
			} else {
				if(Ext.isDefined(record.get('holidayCheck')) && isNullOrEmpty(record.get('holidayCheck'))){
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
        }
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        tooltip : getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        sortable: true,
        renderer: function(value, meta, record) {
        	if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id)){
        		if(record.store.data.length-1 == meta.recordIndex){
        	return "<div class='addButtonClsForGridActionCls' data-qtip='Add' style='marginRight: 20 auto !important'></div>";
        		}

        	}else{
        		return '';
        	}
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                return "<div class='deleteButtonClsForGridActionCls'  auto !important'></div>";
            }
            return '';
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
            	var columnDataIndex = obj.context.field;
            	if (!isNullOrEmpty(editor.record.data.id)) {
                	if (columnDataIndex == "leaveType") {
                        return false;
                    }
                }
            }
        }
    }],
    getAllSelectedLeaveTypeIds: function(combo){
    	var ids = [];
    	this.getStore().each(function(rec){
    		if(combo.getValue()!=rec.get('leaveType') && !isNullOrEmpty(rec.get('leaveType'))){
    			ids.push(rec.get('leaveType'));
    		}
    	});
    	return ids.join();
    }
});
