/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.leavemanagement.report.LMEmployeeLeaveBalanceReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.lmemployeeleavebalancereportgrid',
    store: 'leavemanagement.report.LMEmployeeLeaveBalanceReportGridStore',
    title: getServiceRequestTranslation('EMPLOYEE_LEAVE_BALANCE_REPORT'),
    border: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },  
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'leavemanagement.report.LMEmployeeLeaveBalanceReportGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    plugins:[{
    	ptype: 'rowexpander',
    	pluginId:'preAdmissionPaymentRowExpander',
    	rowBodyTpl:new Ext.XTemplate('<table style="border:1px solid black; width: 50%;">', 
    			'<tr>',
    			'<th style="width:150px;border-bottom:1px solid black;background-color: #f2f2f2">' + getPersonModuleTranslation('LMAS_LEAVE_TYPE') + '</th>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getPersonModuleTranslation('LMAS_ENTITLED') + '</th>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getPersonModuleTranslation('LMAS_APPLIED') + '</th>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getPersonModuleTranslation('LMAS_APPROVED') + '</th>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getPersonModuleTranslation('LMAS_AVAILED') + '</th>',
    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getPersonModuleTranslation('LMAS_BALANCE') + '</th>',
    			'</tr>',
    			'<tpl for="wsHREmpLeaveBalance">',
    			'<tr>',
    			'<td style="width:150px;text-align:center">{hrLeaveTypeIDCode.value}</td>',
    			'<td style="width:100px;text-align:center">{[this.checkBlankVal(values.entitled)]}</td>',
    			'<td style="width:100px;text-align:center">{[this.checkBlankVal(values.applied)]}</td>',
    			'<td style="width:100px;text-align:center">{[this.checkBlankVal(values.approved)]}</td>',
    			'<td style="width:100px;text-align:center">{[this.checkBlankVal(values.availed)]}</td>',
    			'<td style="width:100px;text-align:center">{[this.checkBlankVal(values.balance)]}</td>',
    			'</tr>',    		
    			'</tpl>',
    			'<tfoot>',
    			'<tr>',
    			'<td style="width:150px;text-align:center;font-weight: bold;">Total</td><td style="width:100px;text-align:center;">{[this.summaryTotalLeaveBalance(values.wsHREmpLeaveBalance,"entitled")]}</td><td style="width:100px;text-align:center;">{[this.summaryTotalLeaveBalance(values.wsHREmpLeaveBalance,"applied")]}</td><td style="width:100px;text-align:center;">{[this.summaryTotalLeaveBalance(values.wsHREmpLeaveBalance,"approved")]}</td><td style="width:100px;text-align:center;">{[this.summaryTotalLeaveBalance(values.wsHREmpLeaveBalance,"availed")]}</td><td style="width:100px;text-align:center">{[this.summaryTotalLeaveBalance(values.wsHREmpLeaveBalance,"balance")]}</td>',
    			'</tr>',
    			'</tfoot>',
    			'</table>',{
    		timeFormatChange: function(inputValue) {
    			return timeRender(inputValue);
    		},
    		checkBlankVal : function(val){
    			if(!isNullOrEmpty(val)){
    				return Ext.util.Format.number(val, '0.00');
    			}
    			else{
    				return '-';	
    			}
    			
    		},
    		summaryTotalLeaveBalance : function(leaveBal, key){
    			var sum=0;
    			if(!isNullOrEmpty(leaveBal) && leaveBal.length>0){	
    				leaveBal.forEach(function(leave) {
    					if(!isNullOrEmpty(leave[key]))
    					{
    						sum = sum + leave[key];
    					}
    				});

    				return (sum > 0 ? Ext.util.Format.number(sum, '0.00') : '-');
    			}
    		}
    	})
    }],
    
   
    initComponent: function() {
        var grid = this;
        //grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'exportReportItemId',
        tooltip: getCommonTranslation('EXPORTREPORTS'),
        text: getCommonTranslation('EXPORTREPORTS'),
    }],
    columns: [{
        header: getPersonModuleTranslation('HRM_EMP_ID'),
        dataIndex: 'employeeCode',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'employeeName',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('HRM_DEPT'),
        dataIndex: 'department',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('DESIGNATION'),
        dataIndex: 'designation',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('LMAS_ENTITLED'),
        dataIndex: 'entitled',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
        	if (!isNullOrEmpty(value)) {
                return Ext.util.Format.number(value, '0.00');
            } 
        }
    }, {
        header: getPersonModuleTranslation('LMAS_APPLIED'),
        dataIndex: 'applied',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('LMAS_APPROVED'),
        dataIndex: 'approved',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('LMAS_AVAILED'),
        dataIndex: 'availed',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('LMAS_BALANCE'),
        dataIndex: 'balance',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
        	if (!isNullOrEmpty(value)) {
                return Ext.util.Format.number(value, '0.00');
            } 
        }
    }]
});