/**
 * @author Ankur.Jaiswal
 */
Ext.define('Academia.view.leavemanagement.report.LMEmployeeLeaveReportFilter', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.lmemployeeleavereportfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	plugins : "formlabelrequired",
	isMinWidthNotRequired: true,
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[ {
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('REQUESTER_NAME_OR_ID'),
			name: 'requesterNameOrId',
			itemId: 'requesterNameOrIdItemId',
			store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
			valueField: 'id',
			displayField: 'valueCode',
			// editable: false,
			forceSelection: true,
			queryParam: 'name',
			minChars: 3,
			typeAhead: false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents: 'true',
			hideTrigger: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'datefield',
			name: 'lmFromDateId',
			itemId: 'lmFromDateId',
			vtype: 'daterange',
			editable: false,
			allowBlank: false,
			fieldLabel: getCommonTranslation('LM_FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			endDateField: 'lmToDateId',
			vtype: 'daterange'
		},{
			xtype: 'datefield',
			name: 'lmToDateId',
			itemId: 'lmToDateId',
			vtype: 'daterange',
			editable: false,
			allowBlank: false,
			fieldLabel: getCommonTranslation('LM_TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			startDateField: 'lmFromDateId',
			vtype: 'daterange'
		}]
		
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'lmConfigStatus',
			itemId: 'lmConfigStatus',
			fieldLabel: getPersonModuleTranslation('STATUS'),
			store: 'leavemanagement.leaveapprovalsetup.LMLeaveRequestStatusStore',
			fieldLabel: getPersonModuleTranslation('STATUS'),
			valueField: 'value',
			displayField: 'value',
			editable: false,
			listeners: {
				renderer: function(combo) {
					var a = combo
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'lmLeaveTypeId',
			itemId: 'lmLeaveTypeId',
			displayField: 'value',
			valueField: 'id',
			store:'leavemanagement.LeaveTypeStore',
            forceSelection: true,
            editable: false,
            typeAhead: true,
			fieldLabel: getCommonTranslation('LEAVE_TYPE'),
		}]

	},{
		xtype: 'fieldset',
		collapsible : true,
		itemId: 'moreDetailsEmployeeLeaveReport',
		//collapsed: true,
		title: getCommonTranslation('MORE_FILTERS'),
		titleCollapse: true,
		width: '100%',
		defaults : {
			labelAlign:'top',
//			tdAttrs: { style: 'padding: 5px;' }
		},
		style: {
          	 marginTop: '33px!important'
         },
		items:[{
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
        items: [{
        xtype: 'customcombobox',
        itemId: 'cmbDepartment',
        fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
        valueField: 'id',
        displayField: 'name',        
        name: 'DEPARTMENT',
        editable: false,
        triggerAcation: 'all',
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.departmentFilterStore');
                combo.bindStore(store);
            }
        }
    },{
		xtype: 'customcombobox',
		itemId:'designationCombo',
		fieldLabel: getPersonModuleTranslation('DESIGNATION'),
		store: 'common.DesignationTypeStore',
		valueField: 'id',
		displayField: 'value',        
		name : 'DESIGNATION_ID',
		editable: false,
		triggerAcation: 'all',
	}]
    }]
         },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			disabled:true,
			itemId: 'searchBtn',
			//formBind:true,
			// buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});