/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.leavemanagement.report.LMEmployeeLeaveSLAReportFilter', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.lmemployeeleaveslareportfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	plugins : "formlabelrequired",
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name: 'slaLeaveFromDateId',
			itemId: 'slaLeaveFromDateId',
			vtype: 'daterange',
			editable: false,
			disabled:true,
			allowBlank: false,
			fieldLabel: getPersonModuleTranslation('LM_LEAVE_FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			endDateField: 'slaToDateId',
			vtype: 'daterange'
		},{
			xtype: 'datefield',
			name: 'slaLeaveToDateId',
			itemId: 'slaLeaveToDateId',
			vtype: 'daterange',
			editable: false,
			disabled:true,
			allowBlank: false,
			fieldLabel: getPersonModuleTranslation('LM_LEAVE_TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			startDateField: 'slaFromDateId',
			vtype: 'daterange'
		}]
		
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
            xtype: 'textfield',
            itemId: 'academyLocationItemId',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION_NAME'),
            name: 'academyLocation',
            disabled:true,
            readOnly: true,
            allowBlank: false
        },{
			xtype: 'customcombobox',
			name: 'lmLeaveTypeId',
			itemId: 'lmLeaveTypeId',
			displayField: 'value',
			valueField: 'id',
			store:'leavemanagement.LeaveTypeStore',
            forceSelection: true,
            editable: false,
            typeAhead: true,
			fieldLabel: getCommonTranslation('LEAVE_TYPE'),
		}]	
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			//disabled:true,
			itemId: 'searchBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});