/**
 * @author Soham Gurjar
 */
Ext.define('Academia.view.lecturerCostingDefinition.DownloadCourseCostingForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadcoursecostingform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		items : [{
			xtype: 'fieldcontainer',
            layout: 'hbox',
            width: '100%',
            defaults: {
                labelAlign: 'top',
                width: 256,
            },
            items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				typeAhead : true,
				editable : true,
				queryMode:'local',
             	forceSelection : true,
             	anyMatch : true,
             	allowBlank:false
			},{
				xtype: 'multiselectcombofield',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				itemId: 'courseCodeId',
				name: 'COURSE_ID',
				valueField:'id',
				displayField:'coursecodeName',
				store:Ext.create('Academia.store.lecturercostingdefinition.LCDCourseStore'),
				allowBlank:true,
				disabled:true,
				width: 536,
				queryParam:'name',
				_isStoreLoadCalled:true,
    			minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
			//	cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
    			  listConfig: {
    				  listeners: {
  						beforeshow: function(picker) {
  							picker.minWidth = picker.up('combobox').getSize().width;
  						}
      				  },
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{courseCode} / {courseName}'+ 
    	                    '</div>';
    	                }
    	            }
			},]
        },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top',
				width: 256,
			},
			items :[{
				xtype: 'multiselectcombofield',
				fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
				name:'COURSE_VARIENT_ID',
				itemId: 'courseVariantId',
			    store:'lecturercostingdefinition.LCDCourseVariantStore',
				displayField: 'value',
				valueField: 'id',
				typeAhead:true,
				queryParam:'name',
    			minChars:3,
				width: 536,
				allowBlank:true,
				_isStoreLoadCalled:true,
				disabled:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				//cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
    			  listConfig: {
    				  listeners: {
  						beforeshow: function(picker) {
  							picker.minWidth = picker.up('combobox').getSize().width;
  						}
      				  },
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
    	            },
    	            listeners:{
			            expand: function(combo) {
			                // Ensure the picker is shown even if the store is already loaded
			                combo.ignoreSelection = 0;
			            }
					}
			},{
				xtype: 'multiselectcombofield',
				fieldLabel: getCommonTranslation('LECTURER'),
				itemId: 'lecturerId',
				name: 'lecturer',
				valueField:'id',
				autoloadStore: false,
				displayField:'value',
				store:Ext.create('Academia.store.lecturercostingdefinition.MappedLecturerStore'),
				allowBlank:true,
				disabled:true,
				typeAhead:true,
				width: 536,
				queryParam:'name',
    			minChars:3,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				//cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
    			  listConfig: {
    				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
    				  },
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
    	            }
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top',
				  width: 256,
			},
			items :[{
				xtype: 'multiselectcombofield',
				name: 'programWiseProgram',
				width: 536,
				itemId: 'programWiseProgramId',
				fieldLabel: getProgramandcourseTranslation('PROGRAM_BATCH'),
				store: Ext.create('Academia.store.lecturercostingdefinition.LCDProgramBatchPeriodStore'),
				displayField:'valueCode',
				valueField:'id',
				queryParam:'programName',
				typeAhead : true,
				forceSelection:true,
				hideTrigger:false,
				triggerAction: 'all',
				disabled:true,
				minChars:3,
				autoloadStore:false,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},,{
				xtype: 'multiselectcombofield',
				name: 'programWisePeriod',
				itemId:'programWisePeriodId',
				fieldLabel: getCourseTxCommonTranslation('PERIOD'),
				store: Ext.create('Academia.store.lecturercostingdefinition.LCDProgramBatchPeriodStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead : true,
				forceSelection:true,
				hideTrigger:false,
				triggerAction: 'all',
				minChars:3,
				disabled:true,
				width: 536,
				queryParam:'programName',
				autoloadStore:false,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
            width: 'auto',
    		layout: 'hbox',
    		cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
			items: [{
	           	 xtype: 'button',
	        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
	             itemId: 'downoladBtnId',
	             formBind : true,
	             ui: 'CustomBtnSubmit'
	        },{
                xtype: 'button',
                text: getCourseTxCommonTranslation('RESET'),
                itemId: 'resetBtn',
                //buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
		}]
	}]
});
