/**
 * @author Soham.Gurjar
 */
var lcdCourseGridStore = Ext.create('Academia.store.lecturercostingdefinition.LCDCourseGridStore');
Ext.define('Academia.view.lecturerCostingDefinition.LecturerCostingCourseGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.lecturercostingcoursegrid',
	store : lcdCourseGridStore,
	border: true,
	title: getCommonTranslation('LECTURER_COSTING_LIST'),
	autoScroll: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			itemId : 'custompagingtoolbarId',
			plugins:['pagesize'],
			store : lcdCourseGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar : [ {xtype : 'button',
		text:getCommonTranslation('ADD_COST'),
		itemId:'addCourseCostingBtn',
		disabled:true}
	],
	columns : [{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTermName',
		flex : 0.1
	},
	{
		header : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		dataIndex : 'programName',
		flex : 0.15
	},
	{
		header : getCourseTxCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 0.1
	},
	{
		header : getCourseTxCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 0.1
	},{
		header : getCommonTranslation('LECTURER'),
		dataIndex : 'facultyName',
		flex : 0.1
	},	{header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 0.2}, 
		{
			header : getCommonTranslation('COST_DETAILS'),
			dataIndex : 'costDetails',
			flex : 0.1,
			align: 'center',
			renderer:function(value,meta,record){
				if(record.data.isCostDtlsPresent)
				return '<a href=#>'+getProgramandcourseTranslation('VIEW')+'</a>'
				else
				return '-'
			}

		},
	{
		header : getProgramandcourseTranslation('MAPPING_STATUS'),
		dataIndex : 'mappingStatus',
		flex : 0.1
	}
	]

});
