/**
 * @author Soham.Gurjar
 */
Ext.define('Academia.view.lecturerCostingDefinition.LecturerCostingServiceFilter', {   
	extend : 'Academia.view.common.IdGeneratorCustomForm',
	alias : 'widget.lecturercostingservicefilter',
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	cls:'customSearchInnerPanel',
    //layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
		        		xtype:'multiselectcombofield',
		        		itemId:'serviceId',
		        		name:'serviceId',
		        		fieldLabel:getProgramandcourseTranslation('SERVICE'),
		        		displayField:'value',
		        		valueField:'id',
		        		store:Ext.create('Academia.store.lecturercostingdefinition.LCDServiceStore'),
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			minChars:3,
		    			autoloadStore: false,
		    			width: 536,
		    			queryParam:'serviceName',
		    			typeAhead:true,
		        		listConfig: {
		        			listeners: {
		        				beforeshow: function(picker) {
		        					picker.minWidth = picker.up('combobox').getSize().width;
		        				}
		        			},
		        			loadingText: getCommonTranslation('SEARCHING'),
		        			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
		        		}
		        	}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
		        		xtype:'multiselectcombofield',
		        		itemId:'serviceCoordinatorId',
		        		name:'serviceCoordinatorName',
		        		fieldLabel:getCommonTranslation('SERVICE_COORDINATOR'),
		        		displayField:'staffName',
		        		valueField:'coordinatorId',
		        		store:Ext.create('Academia.store.lecturercostingdefinition.LCDServiceCoordinatorStore'),
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			minChars:3,
		    			autoloadStore: false,
		    			width: 536,
		    			queryParam:'name',
		    			typeAhead:true,
		        		listConfig: {
		        			listeners: {
		        				beforeshow: function(picker) {
		        					picker.minWidth = picker.up('combobox').getSize().width;
		        				}
		        			},
		        			loadingText: getCommonTranslation('SEARCHING'),
		        			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
		        		}
		        	}]
				},{
		            xtype: 'fieldcontainer',
		           layout : {
		    			type : 'hbox'
		    		},
		    		style:{
		    			'margin-left':'-32px !important'
		    		},
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SEARCH'),
		                itemId: 'lcdServiceSearchBtn',
		                buttonAlign: 'left',
		                formBind:true,
		                ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE
		            },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetButton',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
		        }]
});