Ext.define('Academia.view.manageCeremony.CeremonyAddMappingBatchPeriodGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.ceremonyaddmappingbatchperiodgrid',
	title : getCommonTranslation('PERIOD'),
	store: 'feeandpayment.ALProgramBatchPeriodList',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	border: true,
	 dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	            xtype: 'custompagingtoolbar',
	            plugins: ['pagesize'],
	            store: 'feeandpayment.ALProgramBatchPeriodList',
	            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	            displayInfo: true
	        }]
	    }],
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitFeeMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'batchPeriodType',
		itemId:'batchPeriodType',
		store: 'manageCeremony.CeremonyBatchPeriodStore',
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'qry',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'programGroupName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		dataIndex : 'codeValue',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1	 
	}]
});