/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.manageCeremony.ManageCeremonyStudentMappedGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.manageCeremonyStudentMappedGrid',
	store : 'manageCeremony.ManageCeremonyStudentMappedStore',
	title: getExaminationTranslation('MAP_STUDENT_LIST'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType : 'checkboxmodel',
	selModel : {
		mode : 'MULTI',
		showHeaderCheckbox : true
	},
	headerFix:{
	    headerFix: true,
	    portalIdsWithStructure: {
	    'manageCeremonyStudentMappedStructure':1
	 }},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'manageCeremony.ManageCeremonyStudentMappedStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	isGridConfigurable: true,
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('EXTERNAL_REF_NUMBER'),
		dataIndex : 'externalRefNumber'
	},{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation'
	},{
		header : getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'programGroup',
		flex:1
	},{
		header : getExaminationTranslation('PROGRAM_CODE_NAME'),
		dataIndex : 'program',
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batch'
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'period'
	},{
		header : getCommonTranslation('WILL_ATTEND_GRADUATION_CEREMONY'),
		dataIndex : 'isAttending',
		sortable : false,
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			switch(val) {
			  case 'YES':
				 return getFeeAndPaymentCommonTranslation('YES')
			    break;
			  case 'NO':
				  return  getFeeAndPaymentCommonTranslation('NO')
			    break;
			  case 'DEFFERED_TO_MARCH':
				  return getCommonTranslation('DEFFERED_TO_MARCH')
			    break;
			  default:
				  return val;
			}
		}
	}]
});