/**
 * @author Pankaj Sisodiya
 */

Ext.define('Academia.view.manageCeremony.StudentMappedCeremonyWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.studentMappedCeremonyWin',
	title: getCommonTranslation('MAP_STUDENT'),
    modal: true,
    resizable: false,
    frame: true,
    maxHeight:450,
	items: [{
		xtype: 'form',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		plugins : "formlabelrequired",
		items: [{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId:'studentId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'manageCeremony.CeremonyStudentMappedStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			 allowBlank:false,
			 triggerAction: '',
 			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
        },{

    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SAVE") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'closeBtn',
    			name: 'closeBtn',
    			text: getCommonTranslation("CANCEL"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}]
    	
    	}]	
	}]
});
