/**
 * @author Deepak.Nigam
 */
Ext.define('Academia.view.manageDetention.EventList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.eventlist',
    store : 'manageDetention.DetentionAvailableEventStore',
    title : getExaminationTranslation('EVENT_LIST'),
    border: true,
    autoScroll: false,
    frame:false,
	selType:'checkboxmodel',
    viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store :  'manageDetention.DetentionAvailableEventStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	}]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
    tbar: [{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
        xtype: 'button',
        itemId: 'btnAdd',
        text : getExaminationTranslation('APPLY_CRITERIA'),
        tooltip: getExaminationTranslation('APPLY_CRITERIA'),
        ui: 'CustomBtnSubmit',
        scale: CONSTANTS.BUTTONSIZE
    }]
    },/*{
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    },{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('ADD'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },{
	 	xtype : 'splitbutton',
        itemId:'spBtnMoreActions',
        text : getCommonTranslation('MOREACTIONS'),
        menu:[{
            text:getExaminationTranslation('APPLY_TO'),
            itemId:'applyToBtn'
        },{
			text:getExaminationTranslation('DETAIN_STUDENT'),
			itemId:'detainStudentBtn'
		}]
    }*/],
    columns: [{
		  	header : getExaminationTranslation('COURSE_CODE'),
		  	dataIndex : 'courseCode',
		  	flex:1
       },{
            header : getExaminationTranslation('COURSE_NAME'),
	        dataIndex : 'courseName', 
	        flex:1
       },{
		  	header : getExaminationTranslation('COURSE_VARIANT'),
		  	dataIndex : 'courseVariantName',
		  	flex:1
       },{
		  	header : getExaminationTranslation('DETAILED_SEQUENCE'),
		  	dataIndex : 'eventName',
		  	flex:1
       }]
});