/**
 * @author Deepak.Nigam
 */
Ext.define('Academia.view.manageDetention.manageDetentionGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.managedetentiongrid',
    store: 'manageDetention.DetentionCriteriaListStore',
    title: getExaminationTranslation('MANAGE_DETENTION'),
    border: true,
    frame: false,
    //	selType:'checkboxmodel',
    headerFix: {
        headerFix: true,
        portalIdsWithStructure: {
            'managedetentionstrucure': 1
        }
    },
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
        mode: 'MULTI',
        showHeaderCheckbox: true,
        allowDeselect: false,
        checkOnly: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'manageDetention.DetentionCriteriaListStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
        xtype: 'splitbutton',
        itemId: 'spBtnMoreActions',
        text: getCommonTranslation('MOREACTIONS'),
        menu: [{
            text: getExaminationTranslation('APPLY_TO'),
            itemId: 'applyToBtn'
        }, {
            text: getExaminationTranslation('DETAIN_STUDENT'),
            itemId: 'detainStudentBtn'
        }]
    }],
    columns: [{
        header: getExaminationTranslation('DETENTION_CRITERIA_NAME'),
        dataIndex: 'criteriaName',
        flex: 1
    }, {
        header: getExaminationTranslation('ATTENDANCE_PERCENTAGE_FROM'),
        dataIndex: 'fromPercentage',
        flex: 1,
        renderer: function (value, meta, record) {
            return value + "%";
        }
    }, {
        header: getExaminationTranslation('ATTENDANCE_PERCENTAGE_TO'),
        dataIndex: 'toPercentage',
        flex: 1,
        renderer: function (value, meta, record) {
            return value + "%";
        }
    }, {
        header: getExaminationTranslation('ATTENDANCE_PERCENTAGE_AS_ON_DATE'),
        dataIndex: 'tillAttendanceDate',
        flex: 1,
        renderer: function (date) {
            return dateRender(date);
        }
    }, {
        header: getExaminationTranslation('DETENTION_GRADE'),
        dataIndex: 'detainGrade',
        flex: 1
    }]
});