/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.manageMarksModeration.ManageMarksModerationFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.managemarksmoderationfilter',
    plugins: "formlabelrequired",
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
   // method: 'POST',
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'courseId',
                itemId: 'courseItemId',
                //store: 'examinationcenters.evaluation.CourseByAcademyLocationStore',
				store:	Ext.create('Academia.store.attendance.CoursesForVariantMapping'),
                fieldLabel: getCommonTranslation('COURSE'), 
                valueField: 'id',
    			displayField: 'value',
    			queryParam:'courseName',      
                minChars: 3, 
				width: 256,  
                typeAhead: false,
                //triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			triggerAction: '',
                enableKeyEvents: 'true',
                hideTrigger: false,
                forceSelection: true,
                allowBlank: false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;    
							picker.maxWidth = picker.up('combobox').getSize().width;       
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'evaluationplan',
                itemId: 'evalautionPlanId',
                store: 'examinationcenters.assessmentEvent.EvaluationPlanForEventStore',
                fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
                valueField: 'id',
                width: 256,
                displayField: 'value',
                queryParam: 'evaluationPlanNumber',
                minChars: 3,
                typeAhead: false,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: 'true',
                hideTrigger: false,
                forceSelection: true,
                disabled: true,
                allowBlank: false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
            }, {
                xtype: 'multiselectcombofield',
                name: 'courseVariant',
                itemId: 'courseVariantItemId',
                store: 'attendance.VariantMappedToSpecialGrade',
                fieldLabel: getExaminationTranslation('COURSE_VARIANT'),
                displayField: 'value',
                valueField: 'id',
                minChars: 3,
    			autoloadStore: false,
                typeAhead: true,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: 'true',
                hideTrigger: false,
                forceSelection: true,
                allowBlank: false,
                disabled: true,
                //width: 536,
                cls:'placementProgramMultiselect',
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.width = 'auto';
                            setTimeout(function() {
                                picker.el.dom.style.width = 'auto';
                                picker.el.dom.style.minWidth = picker.up('combobox').getSize().width + 'px';
                            }, 10);
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'groupingcombobox',
                name: 'evaluationLevelName',
                itemId:'evaluationLevelNameId',
                labelAlign:'top',
              //  queryMode: 'local',
                groupField: 'code',
                groupDisplayField: 'code',
                store: 'manageMarksModeration.ManageMarksModerationEvalSchemeLevelStore',
                fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
                displayField: 'value',
                //valueField: 'id' ,
               // minChar : 3,
                disabled:true,
                allowBlank: false,
                forceSelection: true,
               // typeAhead: true,
               /*listeners:{
            	   dirtychange:function(obj,rec){
                		debugger
                		var data=rec[0].data.code;
                		//obj.nextSibling().setValue(data);
                	}
                }*/
            }]
        }, {
            xtype: 'fieldset',
            title: getTransportTranslation('MORE_FILTERS'),
            layout: 'vbox',
            frame: true,
            collapsible: true,
            collapsed: true,
            style: {
                marginTop: '33px!important',
				paddingTop:'25px!important'    
            },
            width: '100%',
            itemId: 'moreFilterId',
            items: [{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'customcombobox',
                    name: 'programId',
                    itemId: 'programItemId',
                    store: 'examinationcenters.reports.CriteriaBasedProgramStore',
                    fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                    valueField: 'id',
                    displayField: 'valueSecondValue',
                    queryParam: 'name',
                    minChars: 3,
                    width: 256,
                    typeAhead: false,
                    triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                    enableKeyEvents: 'true',
                    hideTrigger: false,
                    forceSelection: true,
					disabled:true,  
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{value}' +
                                '</div>';
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'batchId',
                    itemId: 'batchItemId',
                    store: 'examinationcenters.reports.SpecialGradeBatchStore',
                    fieldLabel: getExaminationTranslation('BATCH'),
                    valueField: 'id',
                    displayField: 'value',
                    queryParam: 'name',
                    minChars: 3,
                    width: 256,
                    disabled: true,
                    forceSelection: true,
                    typeAhead: true,
                    disabled: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'periodId',
                    itemId: 'periodItemId',
                    store: 'examinationcenters.reports.SpecialGradePeriodStore',
                    fieldLabel: getExaminationTranslation('PERIOD'),
                    valueField: 'id',
                    displayField: 'value',
                    disabled: true,
                    queryParam: 'name',
                    minChars: 3,
                    width: 256,
                    forceSelection: true,
                    typeAhead: true,
                    disabled: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                    }
                }]
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'resetBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});