/**
 * @author Gajendra Verma
 */
Ext.define('Academia.view.managetarget.ActualAdmissionsOfferApplicantCountGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.actualadmissionsofferapplicantcountgrid',
    store: 'managetarget.AdmissionOfferApplicantCountGridStore',
    title: getAdmissionTranslation('TOTAL_ACTUAL_ADMISSION_OFFER'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems : [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'managetarget.AdmissionOfferApplicantCountGridStore',
    		emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    		displayInfo : true
    	} ]
    }],
    columns: [{
        header: getCommonTranslation('APPLICATION_ID'),
        dataIndex: 'applicationCode',
        flex: 0.5,
        sortable: true,
        renderer : function(value){
        	if( !isNullOrEmpty(value) && value != 0 ){
        		return  '<a href="#">'+value+'</a>';
        	} else {
        		return  value;
        	}
		}
    }, {
        header: getAdmissionTranslation('APPLICANT_NAME'),
        dataIndex: 'applicantName',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
        		return value;
        	}
        }
    }, {
        header: getCommonTranslation('APPLICATION_DATE'),
        dataIndex: 'applicationDate',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
					return dateRender(value);
			}
        }
    }, {
        header: getCommonTranslation('APPLICATION_OWNER'),
        dataIndex: 'applicationOwnerShortName',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
				return value;
        	}
        }
    }]
});
