Ext.define('Academia.view.managetarget.ManageTargetExportWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.managetargetexportwindow',
	modal: true,
	frame: true,
	title:getPersonModuleTranslation('VIEW_TOTALS_BY'),
	items: [{
		xtype: 'form',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		standardSubmit: false,
		//plugins:"formlabelrequired",    
		items:[{
			xtype: 'customcombobox',
			name: 'academyId',
			itemId:'academyId',
			loadMask:false,
			//store:'personinfo.student.ChedExportTypeStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			//allowBlank:false,
			fieldLabel:getCommonTranslation('ACADEMY'),
			listeners: {
        		render : function(combo){
        			var store=Ext.create('Academia.store.common.AcademyByUserStore');
        			combo.bindStore(store)
        		}
        	}
		},{
			xtype: 'customcombobox',
			name: 'academyLocationId',
			itemId:'academyLocationId',
			loadMask:false,
			//store:'personinfo.student.ChedExportTypeStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			//allowBlank:false,
			hidden: true,
			fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
			listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.user.UserAcademyLocationStore');
        			combo.bindStore(store)
        		}
        	}
		},{
			xtype: 'customcombobox',
			name: 'programGroupId',
			itemId:'programGroupId',
			loadMask:false,
			//store:'personinfo.student.ChedExportTypeStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			//allowBlank:false,
			hidden: true,
			fieldLabel:getCommonTranslation('PROGRAM_GROUP'),
			listeners: {
        		render : function(combo){
        			var store=Ext.create('Academia.store.personinfo.common.personalinfo.AttendanceReportProgramGroupStore');
        			combo.bindStore(store)
        		}
        	}
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				itemId: 'submitBtn',
				text : getCommonTranslation('DOWNLOAD'),
				buttonAlign : 'left',
				ui : 'CustomBtnThird',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}]	
		}]
	}]
});
