/**
 * @author Amit G
 */
Ext.define('Academia.view.managetarget.ManageTargetProgramGroupWiseGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.managetargetprogramgroupwisegrid',
    store: 'managetarget.ManageTargetStore',
    title: getCommonTranslation('VIEW_TARGETS_BY_PROGRAM_GROUP'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	 features: [{
	        ftype: 'summary',
	        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype : 'button',
		itemId : 'exportReportItemId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		formBind:true
	}],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationPrintName',
        flex: 1,
        sortable: true,
		summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('GRAND_TOTAL');
	      }
    },{
        header: getCommonTranslation('PROGRAM_GROUP'),
        dataIndex: 'programGroupName',
        flex: 1,
        sortable: true,
    },{
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYearValue',
        flex: 1,
        sortable: true,
    }, {
        header: getEnquiryTranslation('MT_ENQUIRY_TARGET'),
        dataIndex: 'enquiryTarget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_APPLICATION_TARGET'),
        dataIndex: 'applicationTarget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_ENROLMENT_PREVIOUS_YEAR'),
        dataIndex: 'enrolmentPreviousYear',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_RETURNING_STUDENTS'),
        dataIndex: 'returningStudents',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_ENROLMENT_BUDGET'),
        dataIndex: 'enrolmentBudget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_REVISED_BUDGET'),
        dataIndex: 'revisedBudget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    },{
        header: getEnquiryTranslation('MT_ENROLMENT_TARGET'),
        dataIndex: 'enrolmentTarget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    },{
        header: getEnquiryTranslation('MT_BUILDING_CAPACITY'),
        dataIndex: 'buildingCapacity',
        flex: 1,
        sortable: true
    },{
        header: getEnquiryTranslation('MT_BUILDING_CAPACITY_SPECIALIST'),
        dataIndex: 'buildingCapacitySpecialist',
        flex: 1,
        sortable: true
    }]
});
