/**
 * @author Amit G
 */
Ext.define('Academia.view.managetarget.StaffDetailsManageTargetGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.staffdetailsmanagetargetgrid',
    store: 'managetarget.StaffDetailsManageTargetGridStore',
    title: getAdmissionTranslation('STAFF_WISE_PRESENTATION_TARGETS'),
    border: true,
    autoScroll: true,
    frame: false,
    cls:'emtyMsgDesign',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getAdmissionTranslation('SALES_STAFF'),
        dataIndex: 'staffCode',
        flex: 0.7,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'salesStaff',
        	itemId: 'salesStaffItemId',
        	store:Ext.create('Academia.store.resourceutilization.ActiveUserStore'),
        	allowBlank: true,
        	displayField : 'valueCode',
        	valueField : 'valueCode',
        	triggerAction: 'all',
        	forceSelection: true,
        	queryParam:'name',
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	minChars:3,
        	enableKeyEvents : 'true',
        	listConfig: {
        		listeners: {
        			select: function(obj, record){
        				var grid = Ext.ComponentQuery.query('staffdetailsmanagetargetgrid')[0];
        				var selectedRecord = grid.getSelectionModel().getSelection()[0];
        				if(!isNullOrEmpty(selectedRecord.data.id)){
        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        				}else{
        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        				}
        				recordToBeUpdated.set('staffId','');
        				var flag = true;
        				var itms = grid.getStore().data.items;
        				itms.forEach(function(object){
        					if(object.data.staffId  == record.data.id){
        						flag = false;
        						return false;
        					}
        				});
        				if(flag){
        					if(!isNullOrEmpty(selectedRecord.data.id)){
        						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        					}else{
        						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        					}
        					recordToBeUpdated.set('staffId',record.data.id);

        					var getStaffStructure = grid.up('staffdetailsmanagetargettabstructure');
        					var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
        					var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
        					var modeOfDeliveryId = getStaffStructure.down('#modeOfDeliveryId').getValue();
        					var registrationType = getStaffStructure.down('#registrationType').getValue();
        					var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
        					Ext.Ajax.request({
        						type: 'rest',
        						url: SERVERURL.PATH_STAFF_TARGETACHIEVED_COUNTBYTYPE,
        						method: "GET",
        						params:{
        							academyLocationIds:academyLocationId,
        							intakeYearId:intakeYearId,
        							manageTargetType:'PRESENTATIONS',
        							staffId:record.data.id,
        							modeOfDeliveryId:modeOfDeliveryId,
        							registrationType:registrationType,
        						},
        						success: function(frm, action) {
        							Ext.getBody().unmask();
        							var data = frm.responseText;

        							if(!isNullOrEmpty(selectedRecord.data.id)){
        								var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        							}else{
        								var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        							}
        							recordToBeUpdated.set('actualTargetAchived',data);
        							recordToBeUpdated.set('actualTarget',null);
        							recordToBeUpdated.set('percentageTargetAchieved',null);
        							recordToBeUpdated.set('targetVariance',null);        						}
        					});
        				}else{
        					this.up().reset();
        					showWarningMessage(getCommonTranslation('ALERT'),getAdmissionTranslation('STAFF_NAME_ALREADY_SELECTED'));
        					return false;
        				}
        			},
            		beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND')
        	} 
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(record.data.staffId) && !isNullOrEmpty(value) && value !== '') {
        		return value;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
        		return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    },{
        header: getCommonTranslation('MODE_OF_DELIVERY'),
        dataIndex: 'modeOfDelivery',
        flex: 0.7,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'modeOfDelivery',
        	itemId: 'modeOfDeliveryItemId',
        	store:'common.ModeOfDeliveryStore',
        	allowBlank: true,
        	valueField: 'id',
			displayField: 'value',
        	forceSelection: true,
        	listConfig: {
        		listeners: {
        			select: function(obj, record){
        				var grid = Ext.ComponentQuery.query('staffdetailsmanagetargetgrid')[0];
        				var selectedRecord = grid.getSelectionModel().getSelection()[0];
        				if(!isNullOrEmpty(selectedRecord.data.id)){
        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        				}else{
        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        				}
        				recordToBeUpdated.set('registrationType',null);
        				grid.columns[2].getEditor().setValue(null);
        			},
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        		var editor = rec.column.getEditor();
            	if(!isNullOrEmpty(value) && value !== '') {
            		try{
            			if(Ext.isObject(value)){
            			return value.value;
            			}else{
            				var index = rec.column.getEditor().store.findExact('id',value);
            				if(index !== -1){
            					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
            				}else{
            					rec.tdCls = 'gridInputCustomStyle';
            					return getExaminationTranslation('CLICK_TO_ENTER');
            				}
            			}
        			}
        			catch(e){
        				return null;
        			}
            	}
            	else{
            		rec.tdCls = 'gridInputCustomStyle';
            		return getExaminationTranslation('CLICK_TO_ENTER');
            	}
        }
    
    },{
        header: getCommonTranslation('REGISTRATION_TYPE'),
        dataIndex: 'registrationType',
        flex: 0.7,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'registrationType',
        	itemId: 'registrationTypeItemId',
        	store:'campaignnew.RegistrationTypeStore',
        	allowBlank: true,
        	valueField: 'id',
			displayField: 'value',
			forceSelection: true,
			listConfig: {
        		listeners: {
        			select: function(obj, record){
        				var grid = Ext.ComponentQuery.query('staffdetailsmanagetargetgrid')[0];
        				var selectedRecord = grid.getSelectionModel().getSelection()[0];
        					var getStaffStructure = grid.up('staffdetailsmanagetargetstructure');
        					var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
        					var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
        					var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
        					Ext.Ajax.request({
        						type: 'rest',
        						url: SERVERURL.PATH_FINEINTAKEYEAR_VALIDDATA,
        						method: "GET",
        						params:{
        							academyLocationId:academyLocationId,
        							intakeYearId:intakeYearId,
        							modeOfDelivery:selectedRecord.data.modeOfDelivery,
        							registrationType:record.data.id,
        						},
        						success: function(frm, action) {
        							var data = frm.responseText;
        						},
        						failure: function(frm, action) {
        							var selectedRecord = grid.getSelectionModel().getSelection()[0];
        	        				if(!isNullOrEmpty(selectedRecord.data.id)){
        	        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        	        				}else{
        	        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        	        				}
        	        				recordToBeUpdated.set('registrationType',null);
        	        				grid.columns[2].getEditor().setValue(null);
       		   				   }
        					});
        			},
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	var editor = rec.column.getEditor();
        	if(!isNullOrEmpty(value) && value !== '') {
        		try{
        			if(value==true){
    					return getCommonTranslation("PART_TIME");	
    				}else if(value==false) {
    					return getCommonTranslation("FULL_TIME");	
    				}else{
    					var index = rec.column.getEditor().store.findExact('id',value);
        				if(index !== -1){
        					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
        				}else{
        					rec.tdCls = 'gridInputCustomStyle';
        					return getExaminationTranslation('CLICK_TO_ENTER');
        				}	
    				}
    			}
    			catch(e){
    				return null;
    			}
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
        		return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    }, {
        header: getAdmissionTranslation('SALES_STAFF_PRESENTATION_TARGET'),
        dataIndex: 'actualTarget',
        flex: 0.5,
        sortable: true,
        editor: {
        	xtype: 'numberfield',
        	name: 'salesStaffPresentiontarget',
        	width:50,
        	minValue:0,
        	maxLength: 6,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	itemId: 'salesStaffPresentiontargetItemId',
        	listeners: {
        		change: function(obj, record){
        			var grid = obj.up('grid')
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var SalesSPT = obj.getValue();
        			var actualTargetAchived = selectedRecord.data.actualTargetAchived;
        			if(!isNullOrEmpty(actualTargetAchived) && !isNullOrEmpty(SalesSPT)){
        				if(actualTargetAchived==0 || SalesSPT==0){
        					var targetPercentage=0;
        				}else{
        					var targetPercentage = (actualTargetAchived/SalesSPT)*100;	
        				}
        				var targetVariance = actualTargetAchived - SalesSPT; 
        			}
        			if(!isNullOrEmpty(selectedRecord.data.id)){
						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

					}else{
						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
					}
        			recordToBeUpdated.set('percentageTargetAchieved',targetPercentage);
        			recordToBeUpdated.set('targetVariance',targetVariance);
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    }, {
        header: getAdmissionTranslation('SALES_STAFF_ACTUAL_PRESENTATIONS'),
        dataIndex: 'actualTargetAchived',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        }
    }, {
        header: getAdmissionTranslation('SALES_STAFF_PERCENTAGE_TO_TARGET'),
        dataIndex: 'percentageTargetAchieved',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					
					return Ext.util.Format.number(value, "0.00")+' %';
				}
				catch(e){
					return null;
				}
			}
        }
    }, {
        header: getAdmissionTranslation('SALES_STAFF_VARIANCE'),
        dataIndex: 'targetVariance',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        }
    }, {
        header: getCommonTranslation('ADD'),
        dataIndex: 'addButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: true,
        renderer: function(value, meta, record) {
            if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id))
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        		if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
                    return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
                }	
            return '';
        }
    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
    listeners: {
    	beforeedit: function(editor, context) {
    		if(editor.context.field=='staffCode'){
    			if(!isNullOrEmpty(context.record.data.id)){
    				context.grid.columns[0].getEditor().setReadOnly(true);
    				return context.colIdx !== 0;
    			}else{
    				context.grid.columns[0].getEditor().setReadOnly(false);
    			}

    		}else if(editor.context.field=='actualTarget'){
    			if(!isNullOrEmpty(context.record.data.staffCode)){
    				context.grid.columns[3].getEditor().setReadOnly(false);
    				
    			}else{
    				context.grid.columns[3].getEditor().setReadOnly(true);
    				return context.colIdx !== 3;
    			}

    		}else if(editor.context.field=='modeOfDelivery'){
    			if(!isNullOrEmpty(context.record.data.id)){
    				context.grid.columns[1].getEditor().setReadOnly(true);
    				return context.colIdx !== 1;
    			}else{
    				context.grid.columns[1].getEditor().setReadOnly(true);
    			}

    		}else if(editor.context.field=='registrationType'){
    			if(!isNullOrEmpty(context.record.data.id)){
    				context.grid.columns[2].getEditor().setReadOnly(true);
    				return context.colIdx !== 2;
    			}else{
    				context.grid.columns[2].getEditor().setReadOnly(true);
    			}
    			if(isNullOrEmpty(context.record.data.id) && isNullOrEmpty(context.record.data.modeOfDelivery)){
    				context.grid.columns[2].getEditor().setReadOnly(true);
    				return context.colIdx !== 2;
    			}else{
    				context.grid.columns[2].getEditor().setReadOnly(true);
    			}

    		}
    	}
	},
    getAllSelectedSalesStaffIdsSanctioning: function(combo){
    	var ids = [];
    	this.getStore().each(function(rec){
    		if(combo.getValue()!=rec.get('staffId') && !isNullOrEmpty(rec.get('staffId'))){
    			ids.push(rec.get('staffId'));
    		}
    	});
    	return ids.join();
    }
});
