/**
 *  @author Ramkrishna Yadav
 */

Ext.define('Academia.view.mangeElections.candidate.StudentVoterPoolGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentvoterpoolgrid',
	store : 'election.election.ElectionVoterPoolGridStore',
	border: true,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'election.election.ElectionVoterPoolGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'captureBollotVotesBtn',
		tooltip: getCommonTranslation('CAPTURE_BALLOT_VOTES'),
		text: getCommonTranslation('CAPTURE_BALLOT_VOTES'),
	},{
		xtype: 'button',
		itemId: 'sendMessageBtn',
		tooltip: getCommonTranslation('SEND_MESSAGE'),
		text: getCommonTranslation('SEND_MESSAGE'),

	},{
		xtype: 'button',
		itemId: 'btnDelete',
		tooltip: getCommonTranslation('DELETE'),
		text: getCommonTranslation('DELETE'),
		//glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype:'textfield',
		emptyText: getCommonTranslation('ENTER_THREE_CHAR_BY_STUDENT_ID_NAME'),
		width: 300,
		name:'studentVoterPoolGridSearch',
		itemId:'studentVoterPoolGridSearch',
		cls: 'SearchTextFieldWithSmallHeader'
	},{
		xtype: 'button',
		itemId: 'changeWeightage',
		tooltip: getCommonTranslation('CHANGE_WEIGHTAGE'),
		text: getCommonTranslation('CHANGE_WEIGHTAGE'),

	}],
	columns: [{
		header : getCommonTranslation('ADMISION_ID'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1,
		renderer: function(value, metadata, record) {

			return '<a href="#">' + value + '</a>';
		}
	},{
		header :getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header :getCommonTranslation('INTAKE'),
		dataIndex : 'batchName',
		flex:1
	},{
		header :getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex:1
	},{
		header :getCommonTranslation('VOTING_STATUS'),
		dataIndex : 'votingAction',
		flex:1,
		renderer:function(value) {
			if(!isNullOrEmpty(value)){
				var val;
				if(value == 'VOTED') {
					val = '<span  style="color:Green;">' +getCommonTranslation("VOTED")+ '</span>';
				}else if(value == 'NOT_VOTED') {
					val = '<a href="#" style="color:red;">' +getCommonTranslation("NOT_VOTED")+ '</a>';
				}else{
					val = value;
				}
				return val;
			}else{
				return '-';
			}
		}
	},{
		header :getCommonTranslation('VOTE_WEIGHTAGE'),
		dataIndex : 'weightage',
		flex:1
	}]
});