/**
 *  Ramkrishna Yadav
 */

Ext.define('Academia.view.mangeElections.mangeElections.PrintSheetWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.printsheetwindow',
	modal: true,
	autoScroll:true,
	title: getCommonTranslation('PRINT_ELECTION_SHEET'),
	maxHeight:600,
	items: [{
		xtype: 'form',
		method: 'POST',
		autoScroll:true,
		margin: 0,
		layout: 'anchor',
		standardSubmit: false,
		plugins:"formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			name: 'voterPool',
			itemId: 'voterPoolItemId',
			store:'election.election.ElectionListNameStore',
			fieldLabel: getCommonTranslation('CANDIDATE_LIST'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			forceSelection: true,
			editable: false
		},{
			xtype: 'fieldcontainer',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				handler :function(button) {
					button.up('window').close();
				}
			}]
		}]
	}]
});