/**
 * @author pritam.patil
 * this is Quick search Form Of template in messaging 
 */
Ext.define('Academia.view.messaging.TemplateSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.templatesearchform',
    frame: false,
    cls:'customSearchPanel',
    //title: getMessagingModuleTranslation('QUICK_SEARCH'),
    itemId:'templatesearchformId',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype: 'customcombobox',
			name: 'TEMPLATE_CONFIG_NAME',
            itemId:'templateConfigName',
			fieldLabel: getMessagingModuleTranslation('TEMPLATE_NAME'),
        	store:'messaging.MessageTemplateConfigNameStore',
			valueField: 'code',
			displayField: 'value',
			queryParam:'qry',
			minChars:3,
			allowBlank: true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
        	
		
            /*xtype: 'textfield',
            fieldLabel: getMessagingModuleTranslation('TEMPLATE_NAME'),
            
            name: 'TEMPLATE_CONFIG_NAME',
            itemId:'templateConfigName'*/
        }, {
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_CATEGORY'),
            
            store: 'messaging.MessageCategoryStore',
            editable: false,
            name: 'MSG_CATEGORY',
            itemId: 'messageCategoryOnTemplateListScreen',
            valueField: 'id',                
            displayField: 'code',
            queryMode: 'local'
        },{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_SUBCATEGORY'),            
            store: Ext.create('Academia.store.messaging.MessageSubCategoryStore'),
            editable: false,
            name: 'MSG_SUB_CATEGORY',
            itemId: 'messageSubCategoryOnTemplateListScreen',
            valueField: 'id',
            queryMode: 'local',
            displayField: 'code'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('RECEIPENT_TYPE'),
            
            store: 'messaging.RecipientType',
            editable: false,
            name: 'RECIPIENT_TYPE',
            itemId: 'recipientTypeOnTemplateListScreen',            
            valueField: 'id',
            queryMode: 'local',
            displayField: 'code'
        }, {
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('STATUS'),            
            store: 'messaging.TemplateStatusStore',
            editable: false,
            name: 'STATUS',
            itemId: 'statusCombo',            
            valueField: 'name',
            queryMode: 'local',
            displayField: 'value',
            value:'All'
        },{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('MESSAGE_LANGUAGE'),            
            store: Ext.create('Academia.store.messaging.MessageLanguageComboStore'),
            editable: false,
            name: 'MESSAGE_LANGUAGE',
            itemId: 'msgLanguageCombo',
            valueField: 'code',
            displayField: 'code'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getMessagingModuleTranslation('SEARCH'),
            itemId: 'templateFindButtonId',
            //buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getMessagingModuleTranslation('CLEAR_SEARCH'),
            itemId: 'templateClearSearch',
            //buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});