/**
 * @author Sachin.Bangar
 * this is Quick search Form Of List Of System Events in messaging 
 */
Ext.define('Academia.view.messaging.report.AdhocMessageReportSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.adhocmessagereportsearchform',
    frame: false,
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_ID'),
            name: 'MESSAGE_ID',
            itemId: 'messageId'
        },{
            xtype: 'textfield',
            fieldLabel: getMessagingModuleTranslation('AUTHOR_NAME'),
            name: 'AUTHOR_NAME',
            itemId: 'authorName'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_CATEGORY'),
           // editable: false,
            name: 'MSG_CATAGORY',
            itemId: 'messageCategory',
            valueField: 'id',                
            displayField: 'code',
            forceSelection:true,
//            queryMode: 'local',
            queryParam:'msgCategory',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listeners: {
            	render: function(combo){
            		var store = Ext.create('Academia.store.messaging.MessageCategoryStore');
            		combo.bindStore(store);
            	}
            },
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'  +
	                    '</div>';
	                }
	            }

        },{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_SUBCATEGORY'),
           // editable: false,
            name: 'MSG_SUB_CATAGORY',
            itemId: 'messageSubCategory',
            valueField: 'id',
            //queryMode: 'local',
            displayField: 'code',
            queryParam:'msgSubCategory',
            forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            
            listeners: {
            	render: function(combo){
            		var store = Ext.create('Academia.store.messaging.MessageSubCategoryStore');
            		combo.bindStore(store);
            	}
            },
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'  +
	                    '</div>';
	                }
	            }

        }]
    }, {

        xtype: 'fieldcontainer',
        fieldLabel: '<u>'+getMessagingModuleTranslation('MESSAGE_DATE_BETWEEN')+'</u>',
        labelAlign: 'top',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('START_DATE'),
            name: 'START_DATE',
            itemId : 'startDate',            
            vtype: 'daterange',
            endDateField: 'endDate',
            //minValue: new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
            
        },{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('END_DATE'),
            name: 'END_DATE',
            itemId : 'endDate',
            vtype: 'daterange',
            startDateField: 'startDate',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
        }]
    }, {
        xtype: 'checkboxgroup',
        fieldLabel: '<u>'+getMessagingModuleTranslation('MESSAGE_MODE')+'</u>',
        width: '100%',
        labelAlign: 'top',
        columns: 5,
        vertical: false,
        name: 'DELIVERY_MODE',
        items: [{
			xtype:'checkbox',
			boxLabel: getMessagingModuleTranslation('EMAIL'),
//            name: 'EMAIL',
			name: 'DELIVERY_MODE',
            inputValue: 1,
            itemId: 'EMAIL'
		},{
			xtype:'checkbox',
			boxLabel: getMessagingModuleTranslation('SMS'),
//            name: 'SMS', 
			name: 'DELIVERY_MODE',
            inputValue: 2,
            itemId: 'SMS'
		},{
			xtype:'checkbox',
			boxLabel: getMessagingModuleTranslation('LETTER'),
//            name: 'LETTER',
			name: 'DELIVERY_MODE',
            inputValue: 3,
            itemId: 'LETTER'
		},{
			xtype:'checkbox',
			boxLabel: getMessagingModuleTranslation('SYS_INTERNAL_MSG'),
//            name: 'SYS_INTERNAL_MSG',
			name: 'DELIVERY_MODE',
            inputValue: 4,
            itemId: 'SYS_INTERNAL_MSG'
		},{
			xtype:'checkbox',
			boxLabel: getMessagingModuleTranslation('WEB_LINK'),
//            name: 'WEB_LINK',
			name: 'DELIVERY_MODE',
            inputValue: 5,
            itemId: 'WEB_LINK'
		}]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getMessagingModuleTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getMessagingModuleTranslation('CLEAR_SEARCH'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});