/**
 * @author Varsha Gour
 */
Ext.define('Academia.view.messaging.report.CommunicationHistoryStructure', {
    extend: 'Ext.form.Panel',
    //title: getPersonModuleTranslation('COMMUNICATION_HISTORY'),
    alias: 'widget.communicationhistorystructure',
    cls: 'panelNoSpace',
    plugins:"formlabelrequired",
    autoScroll: true,
    items: [{
        xtype: 'form',
        width:1350,
        items: [{
            xtype: 'panel',
            cls: 'customSearchPanel',
            items: [{
                xtype: 'radiogroup',
                itemId: 'sendmessageId',
                labelAlign: 'top',
                allowBlank: false,
                fieldLabel: getMessagingModuleTranslation('SENT_MESSAGES'),
                items: [{
                    boxLabel: getMessagingModuleTranslation('EMAIL'),
                    name: 'sendMessage',
                    inputValue: 1,
                    checked: true
                }, {
                    boxLabel: getMessagingModuleTranslation('SMS'),
                    name: 'sendMessage',
                    inputValue: 2
                }]
            }, {
                xtype: 'fieldcontainer',
                width: '100%',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
        			width: 256
                },
                items: [{
                    xtype: 'customcombobox',
                    //disabled: true,
                    name: 'recipientName',
                    itemId: 'recipientName',
                    //store: 'messaging.SendMessageReportRecipientStore',
                    //store: Ext.create('Academia.store.messaging.SendMessageReportRecipientStore'),
                    fieldLabel: getMessagingModuleTranslation('RECIPIENT_NAME'),
                    displayField: 'value',
                    valueField: 'value',
                    queryParam: 'query',
                    minChars: 3,
                    //readOnly: true,
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.messaging.SendMessageReportRecipientStore');
                            combo.bindStore(store);
                        }
                    },
                    
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{code}' +
                                '</div>';
                        }
                    },
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR')
                }, {
                    xtype: 'customcombobox',
                    name: 'contactId',
                    itemId: 'contactId',
                    //store: 'messaging.CommunicationHistoryEmailStore',
                    fieldLabel: getMessagingModuleTranslation('EMAIL'),
                    displayField: 'emailId',
                    valueField: 'emailId',
                    editable: false,
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.messaging.CommunicationHistoryEmailStore');
                            combo.bindStore(store);
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'mobileId',
                    itemId: 'mobileId',
                    //store: 'messaging.CommunicationHistoryMobileStore',
                    fieldLabel: getMessagingModuleTranslation('MOBILE_NO'),
                    displayField: 'mobileNumber',
                    valueField: 'mobileNumber',
                    vtype: 'numericValueValidation',
                    hidden: true,
                    editable: false,
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.messaging.CommunicationHistoryMobileStore');
                            combo.bindStore(store);
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'sentby',
                    itemId: 'sentby',
                    store: 'criteriabuilder.userquicksearch.QuickSearchPrintNameStore',
                    fieldLabel: getMessagingModuleTranslation('SENT_BY'),
                    displayField: 'valueCode',
                    valueField: 'id',
                    queryParam: 'printName',
                    minChars: 3,
                    typeAhead: false,
                    //hideTrigger: true,
        			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        			triggerAction: '',
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    forceSelection: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{code}' +
                                '</div>';
                        }
                    }
                }]
            }, {
                xtype: 'fieldcontainer',
                width: '100%',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
        			width: 256
                },
                items: [{
                    xtype: 'customcombobox',
                    name: 'eventName',
                    itemId: 'eventName',
                    store: 'messaging.SendMessageReportEventNameStore',
                    fieldLabel: getMessagingModuleTranslation('EVENT_NAME'),
                    displayField: 'value',
                    valueField: 'code',
                    queryParam: 'eventName',
                    minChars: 3,
                    typeAhead: false,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    forceSelection: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{code}' +
                                '</div>';
                        }
                    }
                }, {
                    xtype: 'datefield',
                    name: 'eventDateForm',
                    itemId: 'eventDateForm',
                    fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE'),
                  //--submitFormat: CONSTANTS.DATE_FORMAT,
                    vtype: 'daterange',
                    endDateField: 'eventDateTill',
                   editable: false,
                    allowBlank : false,
                 listeners: {
                        render: function(field) {
                            return dateFormatRender(field);
                        }
                    },

                }, {
                    xtype: 'datefield',
                    name: 'eventDateTill',
                    itemId: 'eventDateTill',
                    fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE'),
                  //--submitFormat: CONSTANTS.DATE_FORMAT,
                    vtype: 'daterange',
                    startDateField: 'eventDateForm',
                   editable: false,
                    allowBlank : false,
                    listeners: {
                        render: function(field) {
                            return dateFormatRender(field);
                        }
                    }
                }]
            }, {
                xtype: 'fieldcontainer',
                width: '100%',
        		cls: 'customSearchPanelBtnsFieldContainerCls',
        		layout: 'hbox',
                items: [{
                    xtype: 'button',
                    text: getMessagingModuleTranslation('SEARCH'),
                    itemId: 'searchButtonId',
                    ui: 'CustomBtnSubmit',
                    formBind:true,
                    scale: CONSTANTS.BUTTONSIZE
                }, {
                    xtype: 'button',
                    text: getMessagingModuleTranslation('CLEAR_SEARCH'),
                    itemId: 'resetButtonId',
                    hidden: false,
                    ui: 'CustomBtnCancel',
                    scale: CONSTANTS.BUTTONSIZE
                }]
            }]
        }]
      }, {
            xtype: 'communicationhistorylist',
            //itemId: 'communicationhistoryItemId',
            style:{'margin': '-30px 0px 0px 17px'}	
        }]
});