/**
 * @author pritam.patil
 * This is used to show pop up of follow up details on click of follow up button 
 */
Ext.define('Academia.view.messaging.sendmessage.SendMessageWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.sendmessagewindow',
    modal: true,
    autoScroll: true,
    frame: true,
    title: getMessagingModuleTranslation('ANNOUNCEMENT'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'msgDetailsForm',
        items: [{
        	xtype:'hidden',
        	name:'adhocMessageID',
        	itemId:'adhocMessageID'
        },{
        	xtype:'hidden',
        	name:'adhocMessageStatus',
        	itemId:'adhocMessageStatus'
        },{
        	xtype:'hidden',
        	name:'messageTemplates',
        	itemId:'messageTemplates'
        },{    	    
    		xtype:'hidden',
    		name:'wsMsgEventRecipientConfigs',
    		itemId:'wsMsgEventRecipientConfigs'	        		        		
    	},{    	    
    		xtype:'hidden',
    		name:'wsAdhocRecipients',
    		itemId:'wsAdhocRecipients'	        		        		
    	},{
    		xtype : 'hidden',
    		name :'msgRecipientTypeId',
    		itemId : 'msgRecipientTypeItemId'
    	},{
    		xtype : 'hidden',
    		name: 'msgCategoryId',
    		itemId: 'msgCategoryId'
    	},{
    		xtype : 'hidden',
    		name: 'msgSubCategoryId',
    		itemId: 'msgSubCategoryId'
    	},{
    		xtype : 'hidden',
    		name: 'enquiryGridId',
    		itemId: 'enquiryGridId'
    	},{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [ {
                xtype: 'textfield',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_ID'),
                name: 'messageId',
                itemId: 'messageId',
                emptyText: getCommonTranslation('ID_AUTOGENERATE'),
    			readOnly:true
            },{
                xtype: 'textfield',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_NAME'),
                name: 'displayCode',
                itemId: 'messageName',
                allowBlank: false
            }]},{
                xtype: 'fieldcontainer',
                width: '100%',
                layout: {
                    type: 'vbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel:  getMessagingModuleTranslation('SELECT_TEMPLATE'),                
                    name: 'msgTemplateConfigId',
                    emptyText :  getCommonTranslation('ENTER_THREE_CHAR'),      
                    itemId : 'selectTemplate',   
                    displayField : 'templateConfigName',
                    valueField:'id',
                    allowBlank: false ,
                    queryParam :'searchString', 
                  /*  displayTpl: new Ext.XTemplate(
                     		'<tpl for="."between=" ">',
                     		'{[typeof values === "string" ? values : values["templateConfigName"]]} ' +
                     		'</tpl>'
                     		),*/
                    listeners: {
                    	render: function(combo){
                    		var store = Ext.create('Academia.store.messaging.MessagingTemplatesStore');
                    		combo.bindStore(store);
                    	}
                    }
                }]
            },{
                xtype: 'fieldcontainer',
                width: 'auto',
                style:{
                	marginLeft: '-4px'
                },
                items: [{
                    xtype: 'radiogroup',
                    fieldLabel: getMessagingModuleTranslation('SENDING_PRIORITY'), //+' <span class="required" style="color:red"> *</span>',
                    itemId: 'sendingPriority',
                    name:'sendingPriority',
                    width: 500,
                    labelAlign:'top',
                    vertical: false,
                    allowBlank : false,
                    layout: {
                        type: 'hbox'
                    },
                    items: [{
                        boxLabel: getMessagingModuleTranslation('IMMEDIATE'),
                        itemId: 'immediate',
                        name: 'sendingPriority',
                        inputValue: 'IMMEDIATE',
                        checked: true
                    }, {
                        boxLabel: getMessagingModuleTranslation('SCHEDULE'),
                        itemId: 'schedule',
                        name: 'sendingPriority',
                        inputValue: 'SCHEDULE'
                    }]
                }]
            },{
                xtype: 'fieldcontainer',
                width: '100%',
                style:{
                	marginLeft: '3px',
                	marginTop : '-7px'
                },
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                    },
                items: [{
                    xtype: 'datefield',
                    fieldLabel: getMessagingModuleTranslation('SCHEDULE_DATE'),
                    name: 'msgDueDate',
                    hidden: true,
                    editable: false,
                    itemId: 'scheduleDate',
                    listeners: {
                    	render: function(field) {
                    		return dateFormatRender(field);
                    	}
                    },
                    minValue: new Date(),
                  //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT
                },{
                    xtype: 'timefield',
                    name: 'msgDueDateTime',
                    itemId: 'scheduleTime',
                    hidden: true,
                    fieldLabel: getMessagingModuleTranslation('SCHEDULE_TIME'),
                    format: CONSTANTS.DISPLAY_TIME_FORMAT,
                    increment: 30,
                    minValue:Ext.Date.format(new Date(),CONSTANTS.DISPLAY_TIME_FORMAT),
                    editable: false
                }]        
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            style :{
            	marginLeft :'1px',
            	marginTop :'19px'
            },
            items: [{
                xtype: 'button',
                text: getServiceRequestTranslation('SUBMIT'),
                itemId: 'adhocMsgSubmitBtn',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                formBind : true,
                scale: CONSTANTS.BUTTONSIZE              
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'followUpDetailsCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
        }]
    }],
    
    /**
     * This method is used to send message
     */
    sendMessage : function(button,grid){
		baseController = Academia.app.getController('Academia.controller.base.BaseController');
		var formData = button.up('form').getValues();
		var recipientIds = this.getReceipientIds(grid);

		/**
		 * The below changes were done for Applicant Adhoc message
		 */
		var typeId;
		if(formData.msgRecipientTypeId == 10){
			typeId = 32;
		} 		
		else {
			if(formData.msgRecipientTypeId == 8){
				typeId = 42;
			}else{
				typeId = formData.msgRecipientTypeId;
			}			
		}
		
		var json = {
				id: null, 
			    status: null, 
			    msgTemplateConfigId: null, 
			    sendingPriority: formData.sendingPriority, 
			    msgCategoryId:formData.msgCategoryId, 
			    msgSubCategoryId: formData.msgSubCategoryId, 
			    messageId: formData.messageId, 
			    displayCode: formData.displayCode, 
			    wsMsgEventRecipientConfigs: [ 
			        { 
			            msgRecipientTypeId: typeId, 
			            msgTemplateConfigId:formData.msgTemplateConfigId, 
			            selectiveRecipientIds:recipientIds 
			        } 
			    ], 
			    wsAdhocRecipients: null, 
			    approverId: null, 
			    approvalRequired: false, 
			    reviewStatusCode: "APPROVED" 

		};
		
		if(formData.sendingPriority==="SCHEDULE"){
			if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
    			var dateString="";
    			dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
    			json.msgDueDate=dateString;
    		}else{
    			json.msgDueDate= null;
    		}
		}else if(formData.sendingPriority==="IMMEDIATE"){
			/*var now = new Date();
			var dateString = Ext.Date.format(now,'Y-m-d h:i A');*/
			json.msgDueDate=null;
		}else{
			json.msgDueDate= null;
		}
		
		var academyLocation=baseController.getCurrentAcademyLocation();
    	if(!isNullOrEmpty(academyLocation)){
    		json.academyLocationId=academyLocation;
    	}
    	
    	var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
    	if(!isEmpty(currentlyLoggedInUser)){
    		json.authorId=currentlyLoggedInUser.id;
    		json.authorName=currentlyLoggedInUser.value;
    	}
        jsonDataEncode = Ext.encode(json);
		Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.ADOC_MESSAGEING_CREATE,
            jsonData: jsonDataEncode,
            method: 'POST',
            success: function(form, action) {
            	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll(true);
                button.up('window').close();
            }

        });
	},
	
	/**
	 * This method is used to get Ids 
	 */
	getReceipientIds : function(grid){
		var records = grid.getSelectionModel().getSelection();
		var ids = new Array();
		
		if(grid.itemId === 'StudentSearchResultGrid'){
			for(var i = 0 ; i<records.length;i++){
				ids.push(records[i].raw.ADMISSION_ID);
			}
		}/*else if(grid.itemId === 'facultySearchResultGrid' ||grid.itemId === 'applicationsListGrid',grid.itemId ==='trackenquirygrid'){
			for(var i = 0 ; i<records.length;i++){
				ids.push(records[i].raw.ID);
			}
		}*/else if(grid.itemId === 'userSearchresultgrid'){
			for(var i = 0 ; i<records.length;i++){
				ids.push(records[i].raw.USER_ID);
			}
		}else if(grid.url === 'rest/course/getCourseDashlet'){
			for(var i = 0 ; i<records[0].data.studentIds.length;i++){
				ids.push(records[0].data.studentIds[i]);
			}
		}else{
			for(var i = 0 ; i<records.length;i++){
				ids.push(records[i].raw.ID);
			}
		}
		return ids;
	}
});