/*
 * @author Akshay.Kalbhor
 * 
 */
Ext.define('Academia.view.messaging.systemEventMessagingRuleEditor.SearchCriteriaLineItemForMessaging', {
	extend : 'Ext.form.Panel',
	alias : 'widget.searchcriterialineitemformessaging',
	cls: 'panelNoSpace',
	autoScroll: true,
	config : {
		searchConfigDataSourceForMessaging: null,
		group : null,
		index : 0		
	},
	margin: '1 0 0 0',
	padding: '0 1 0 1',
	layout : {
		type : 'hbox',
		align : 'middle',
		flex : 'alleven'
	},
	items : [{
		xtype:'hidden',
		name:'visibility',
		itemId:'visibility'
	},{
		xtype:'hidden',
		name:'whetherEditable',
		itemId:'whetherEditable'
	},{
		xtype: 'text',
		itemId: 'andOrComponent',
		minWidth: '27px'
	},{
		xtype: 'button',
	    itemId: 'lineDeleteButton',
	    cls: 'CustomBodyBtnReject',
	    glyph: ICONGLYPH.DELETEGLYPH,
	    tooltip:'Delete',
	    handler: function() {
	    	var lineItemForm=this.up('panel').getForm();			
			if(lineItemForm){
				//TODO: implement check for "Do not allowed to delete default criteria" 
				//var lineItemFormValues=lineItemForm.getValues();			
				//if(!isEmpty(lineItemFormValues)){
					//if(lineItemFormValues.whetherEditable){
						//showErrorMessage(getCommonTranslation('ERROR'), getMessagingModuleTranslation('CAN_NOT_DELETE_DEFAULT_LINE_ITEM')); //Can not delete default line item  						
					//}else{
						this.up('panel').close();			
					//}
				//}
			}	    		    	
	    }
	}],
	
	 /*
     * returns a Table combobox required for CB.
     */
    createSearchEntitiesTableCombo: function(tableStore, displayFields, valueFields, itemId) {
    	viewReference = this;
        var combo = Ext.create('Ext.form.ComboBox', {
            queryMode: 'local',
            width: 150,
            allowBlank: false,
            store: tableStore,
            cls: 'cbCombo',
            
            width: 'auto',
           /* grow: true,
            growToLongestValue : true,*/
            editable: false,
            displayField: displayFields,
            valueField: valueFields,
            itemId : itemId,
            padding: '2 20 0 2',
            listeners:{
                'change': function( comboReference, newValue, oldValue, eOpts) {
                	if(this.findRecordByValue(newValue).raw != undefined) {
                		viewReference.populateTableColumns(comboReference, this.findRecordByValue(newValue).raw.wsSearchTableColumns);
                	} else {
                		viewReference.populateTableColumns(comboReference, this.store.data.items.pop(newValue).data.wsSearchTableColumns);
                	}
                }
           }
        });
        return combo;
    },
    
    /*
     * returns a columns combobox required for CB.
     */
    createSearchEntitiesColumnsCombo: function(columnsStore, displayFields, valueFields, itemId) {
    	viewReference = this;
        var combo = Ext.create('Ext.form.ComboBox', {
            queryMode: 'local',
            allowBlank: false,
            width: 150,
            store: columnsStore,
            cls: 'cbCombo',
            
            width: 'auto',
           /* grow: true,
            growToLongestValue : true,*/
            editable: false,
            displayField: displayFields,
            valueField: valueFields,
            itemId : itemId,
            padding: '2 20 0 2',
            listeners:{
                'change': function(comboReference, newValue, oldValue, eOpts) {
                	if(this.valueModels[0] != undefined) {
                		viewReference.populateOperators(comboReference, this.valueModels[0].data.dataType);
                	} else {
                		viewReference.populateOperators(comboReference, this.store.data.items.pop(newValue).data.dataType);
                	}
                	
                }
           }
        });
        return combo;
    },
    
    /*
     * returns a Operator combobox required for CB.
     */
    createOperatorCombo: function(comboStore, displayFields, valueFields, itemId) {
    	viewReference = this;
        var combo = Ext.create('Ext.form.ComboBox', {
            queryMode: 'local',
            allowBlank: false,
            store: comboStore,
            width: 150,
            cls: 'cbCombo',
            
            width: 'auto',
            /*grow: true,
            growToLongestValue : true,*/
            editable: false,
            displayField: displayFields,
            valueField: valueFields,
            itemId : itemId,
            padding: '2 20 0 2',
            listeners:{
                'change': function(comboReference, newValue, oldValue, eOpts) {
                	if(this.valueModels[0] != undefined) {
                		viewReference.populateOperands(comboReference, this.valueModels[0].data.noOfOperands);
                	} else {
                		viewReference.populateOperands(comboReference, this.store.data.items.pop(newValue).data.noOfOperands);
                	}
                	
                }
           }
        });
        return combo;
    },
    
    initializeComponent: function() {
    	var tableConfigStore = Ext.create('Academia.store.criteriabuilder.TableConfigs');
    	var storeData = this.getSearchConfigDataSourceForMessaging().getWsSearchConfigTables();
    	tableConfigStore.add(storeData);
        var tableCombo = this.createSearchEntitiesTableCombo(tableConfigStore, 'displayCode', 'id', 'tabCombo');
        this.add(tableCombo); 
    },
    
	populateTableColumns: function(comboReference, selectedTableColumns) {
    	/*
    	 *  while loop to Remove The nextsiblings if present and then add.
    	 */
    	while(comboReference.nextSibling()) {
    		comboReference.up('panel').remove(comboReference.nextSibling());
    	};
    	var columnsConfigStore = Ext.create('Academia.store.criteriabuilder.ColumnConfigs');
    	columnsConfigStore.add(selectedTableColumns);
    	
    	var columnCombo = this.createSearchEntitiesColumnsCombo(columnsConfigStore, 'displayCode', 'id', 'colCombo');
    	comboReference.up('panel').add(columnCombo); 
    },

    populateOperators: function(comboReference, operator) {
    	/*
    	 *  while loop to Remove The nextsiblings if present and then add.
    	 */
    	var lineReference = comboReference.up('panel');
    	while(comboReference.nextSibling()) {
    		comboReference.up('panel').remove(comboReference.nextSibling());
    	}
    	if(operator==='NUMBER') {
    		var integerOperatorStore = this.searchConfigDataSourceForMessaging.initializeOperatorStoreByOperatorName('NUMBER');
			var operatorCombo = this.createOperatorCombo(integerOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='STRING') {
			var stringOperatorStore = this.searchConfigDataSourceForMessaging.initializeOperatorStoreByOperatorName('STRING');
			var operatorCombo = this.createOperatorCombo(stringOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='BOOLEAN') {
			var booleanOperatorStore = this.searchConfigDataSourceForMessaging.initializeOperatorStoreByOperatorName('BOOLEAN');
			var operatorCombo = this.createOperatorCombo(booleanOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='DATE') {
			var dateOperatorStore = this.searchConfigDataSourceForMessaging.initializeOperatorStoreByOperatorName('DATE');
			var operatorCombo = this.createOperatorCombo(dateOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='ENUM') {
 	        var enumOperatorStore = this.searchConfigDataSourceForMessaging.initializeOperatorStoreByOperatorName('ENUM');
 	        var operatorCombo = this.createOperatorCombo(enumOperatorStore, 'displayCode', 'id', 'oprCombo');
 	       lineReference.add(operatorCombo);
 	        
		} else if(operator==='CHAR') {
 	       var charOperatorStore = this.searchConfigDataSourceForMessaging.initializeOperatorStoreByOperatorName('CHAR');
 	       var operatorCombo = this.createOperatorCombo(charOperatorStore, 'displayCode', 'id', 'oprCombo');
 	      lineReference.add(operatorCombo);
 	       
		} else if(operator==='IDENTITY') {
			var identityOperatorStore = this.searchConfigDataSourceForMessaging.initializeOperatorStoreByOperatorName('IDENTITY');
			var operatorCombo = this.createOperatorCombo(identityOperatorStore, 'displayCode', 'id', 'oprCombo');
			lineReference.add(operatorCombo);
			
		} else if(operator==='REF_IDENTITY') {
			 var refIdentityOperatorStore = this.searchConfigDataSourceForMessaging.initializeOperatorStoreByOperatorName('REF_IDENTITY');
			 var operatorCombo = this.createOperatorCombo(refIdentityOperatorStore, 'displayCode', 'id', 'oprCombo');
			 lineReference.add(operatorCombo);
		} 
    },
    
    /*
     * function to populate operands in the line. 
     * @param {comboReference} is the reference of the operator combo whose parent combo has to be fetched
     * for taking the operand datatype.
     * @param {noOfOperands} is the number of operands to be inserted in the line
     */
    populateOperands: function(comboReference, noOfOperands) {
    	/*
    	 *  while loop to Remove The nextsiblings if present and then add.
    	 */
    	while(comboReference.nextSibling()) {
    		comboReference.up('panel').remove(comboReference.nextSibling());
    	};
    	var previousElement = comboReference.previousSibling();
    	var lineReference = comboReference.up('panel');
    	var dataType = null;
    	
    	if(previousElement.valueModels[0] != undefined) {
    		dataType = previousElement.valueModels[0].data.dataType;
    		this.handleOperands(dataType, noOfOperands, lineReference, comboReference);
    	} else {
    		dataType = previousElement.store.data.items.pop(previousElement.value).data.dataType;
    		this.handleOperands(dataType, noOfOperands, lineReference, comboReference);
    	}
    },
    
    handleOperands: function (dataType, noOfOperands, lineReference, comboReference) {
	    	switch(dataType) {
			case "NUMBER":
					this.handleIntegerOperands(noOfOperands, lineReference);
				break;
				
			case "STRING":
					this.handleStringOperands(noOfOperands, lineReference);
				break;
				
			case "BOOLEAN":
					this.handleBooleanOperands(noOfOperands, lineReference, comboReference);
				break;
				
			case "DATE":
					this.handleDateOperands(noOfOperands, lineReference);
				break;
				
			case "ENUM":
					//TODO: add the handleEnumOperator if required.
				break;
			case "CHAR":
					//TODO: add the handle****Operator if required.
				break;
			case "IDENTITY":
					//TODO: add the handle****Operator if required.
				break;
			case "REF_IDENTITY":
					//TODO: add the handle****Operator if required.
				break;
		
		}
    },
    /*
     * method to add the provided component to the container
     * @param: component is the component which should be inserted
     * @param: container is the target component in which the component should be inserted
     * @param: itemId is the id to be set for the component.
     */
    addComponentToContainer: function(component, container, booleanValue/*, itemId*/) {
    	if(component === 'datefield') {
    		var startDate = null;
        	if(component === 'datefield') {
        		startDate = Ext.create('Ext.form.field.Date');
    			startDate.format= CONSTANTS.DATE_FORMAT;
    			//--startDate.submitFormat= CONSTANTS.DATE_FORMAT;
    			startDate.submitFormat= CONSTANTS.NEW_SUBMIT_DATE_FORMAT;
    			startDate.allowBlank= false;
    			startDate.width= 150;
    			startDate.itemId = 'operandField';
    			/*startDate.grow= true;
    			startDate.growToLongestValue= true;*/
        	}
        	container.add(startDate);
    	} else if (component === 'hiddenfield') {
    		hiddenField = Ext.create('Ext.form.field.Hidden');
    		hiddenField.setValue(booleanValue);
    		hiddenField.itemId = 'operandField';
    		container.add(hiddenField);
    	} else if(component === 'numberfield'){
    		field = Ext.create('Ext.form.field.Number');
    		field.itemId = 'operandField';
    		container.add(field);	
    	} else if(component === 'textfield'){
    		field = Ext.create('Ext.form.field.Text');
    		field.itemId = 'operandField';
    		container.add(field);	
    	}
    	return container;
    },
    
    /*
     * method to add a start and end date field to the container.
     * performs date validations with vtypes.
     * @param: component is the component which should be inserted
     * @param: container is the target component in which the component should be inserted
     * @param: itemId is the id to be set for the component.
     */
    addDatePairToContainer : function(component, container) {
    	var startDate=null;
    	var tillDate=null;
    	if(component === 'datefield') {
    		startDate = Ext.create('Ext.form.field.Date');
        	tillDate = Ext.create('Ext.form.field.Date');
        	startDate.itemId = 'startDate';
			startDate.format= CONSTANTS.DATE_FORMAT;
			//--startDate.submitFormat= CONSTANTS.DATE_FORMAT;
			startDate.submitFormat= CONSTANTS.NEW_SUBMIT_DATE_FORMAT;
			startDate.vtype= 'daterange';
			startDate.endDateField='tillDate';
			startDate.allowBlank= false;
			startDate.width= 150;
			/*startDate.grow= true;
			startDate.growToLongestValue= true;*/
			
			tillDate.itemId= 'tillDate';
			tillDate.format= CONSTANTS.DATE_FORMAT;
			//--tillDate.submitFormat= CONSTANTS.DATE_FORMAT;
			tillDate.submitFormat= CONSTANTS.NEW_SUBMIT_DATE_FORMAT;
			tillDate.vtype= 'daterange';
			tillDate.startDateField='startDate';
			tillDate.allowBlank= false;
			tillDate.width= 150;
			tillDate.style=  {
					marginLeft : '20px'
				};
		/*	tillDate.grow= true;
			tillDate.growToLongestValue= true;*/
			
    	}
    	container.add(startDate);
    	container.add(tillDate);
    	return container;
    },
    /**
     * This is to add number in between
     */
    addPairComponentToContainer : function(component, container) {
    	var numberGreaterThan = null;
    	var numberLessThan = null;
    	if(component === 'numberfield') {
    		numberGreaterThan = Ext.create('Ext.form.field.Number');
    		numberLessThan = Ext.create('Ext.form.field.Number');
        	numberGreaterThan.itemId = 'operandField';
        	numberGreaterThan.width = 150;
        	numberGreaterThan.allowBlank= false;
        	
        	numberLessThan.itemId = 'operandField';
        	numberLessThan.width= 150;
        	numberLessThan.allowBlank= false;
        	numberLessThan.style=  {
				marginLeft : '170px'
			};
    	}
    	container.add(numberGreaterThan);
    	container.add(numberLessThan);
    	return container;
    },
    getSearchCriteriaValue:function(){
    	var children = this.query('field');
    	var advancedSearchCriteria = new Object();
    	var operands = new Array();
    	Ext.each(children, function(component) {
    		var componentType = component.getItemId();
    		if(componentType === 'tabCombo') {
				advancedSearchCriteria.searchConfigEntityId = component.value;
			} else if(componentType === 'colCombo') {
				advancedSearchCriteria.searchTableColumnId = component.value;
			} else if(componentType === 'oprCombo') {
				advancedSearchCriteria.searchCriteriaOperatorId = component.value;
			} else if(componentType === 'visibility') {
				advancedSearchCriteria.visibility = component.value;
			} else if(componentType === 'whetherEditable') {
				advancedSearchCriteria.whetherEditable = component.value;
			} else {
				if(component.id.replace(/\d+/g, '') === "datefield-") {
    				operands.push(Academia.utilities.date.DateHelper.formatDate(component.value));
				} else {
					operands.push(component.value);	
				}
				advancedSearchCriteria.operands = operands;
			}
    	
    	});
    	
    	var searchCriteria = new Object();
		searchCriteria.advancedSearchCriteria = advancedSearchCriteria;
		searchCriteria.type ='SQL';
		Ext.each(children, function(component) {
    		var componentType = component.getItemId();
    		if(componentType === 'visibility') {
    			searchCriteria.visibility = true;
			} else if(componentType === 'whetherEditable') {
				searchCriteria.whetherEditable = true;
			}
		});
    	return searchCriteria;
    },
    
    handleIntegerOperands: function(noOfOperands, lineReference) {
    	switch(noOfOperands) {
		case 0: 
			break;
		case 1:
				this.addComponentToContainer('numberfield', lineReference);
			break;
		case 2:
				//this.addComponentToContainer('numberfield', lineReference);
				//this.addComponentToContainer('numberfield', lineReference);
			this.addPairComponentToContainer('numberfield', lineReference);
			break;
		}
    },
    
    handleStringOperands: function(noOfOperands, lineReference) {
    	switch(noOfOperands) {
		case -1: 
			//TODO: implement tag Field as in extjs 5 example
				/*CharOperatorStore = this.getStore('Academia.store.criteriabuilder.states');
				console.log(CharOperatorStore)*/
				/*var tagField = Ext.create('Ext.form.field.Tag', {
			        store:'Academia.store.criteriabuilder.States',
			        reference: 'states',
			        displayField: 'state',
			        valueField: 'abbr',
			        filterPickList: false,
			        queryMode: 'local',
			        publishes: 'value'
		        });
				console.log(tagField)*/
				/*multiselectCombo.model= 'Academia.model.criteriabuilder.OperatorValue',
				multiselectCombo.store= CharOperatorStore;*/
				
				//multiselectCombo.multiSelect = true;
				/*multiselectCombo.doComponentLayout();*/
				//lineReference.add(tagField);
			break;
		case 0: 
			break;
		case 1:
				this.addComponentToContainer('textfield', lineReference);
			break;
		case 2:
				this.addComponentToContainer('textfield', lineReference);
				this.addComponentToContainer('textfield', lineReference);
			break;
		}
    },
    
    handleBooleanOperands: function(noOfOperands , lineReference, comboReference) {
    	switch(noOfOperands) {
		case 0: 
			break;
		case 1:
				var booleanValue;
				/*
				 * the value returned for the true is 28
				 * false is 29
				 */
				if(comboReference.value === 28) {
					booleanValue = 'TRUE';
				} else {
					booleanValue = 'FALSE';
				}
				this.addComponentToContainer('hiddenfield', lineReference, booleanValue);
			break;
		case 2:
			break;
		}
    },
    
    handleDateOperands: function(noOfOperands , lineReference) {
    	switch(noOfOperands) {
		case 0: 
			break;
		case 1:
				this.addComponentToContainer('datefield', lineReference);
			break;
		case 2:
				this.addDatePairToContainer('datefield', lineReference);
			break;
		}
    },
    
    changeLogicalComponentText: function(logicalOperandText) {
    	var component = this.query('text#andOrComponent');
    	if(component.length=1) {
    		component[0].setText(logicalOperandText);
    	}
    	
    },
    
    getComponentById: function(id) {
    	switch(id) {
	    	case 'tabCombo':
	    		return this.query('customcombobox#tabCombo')[0];
	    	break;
	    	
	    	case 'colCombo':
	    		return this.query('customcombobox#colCombo')[0];
		    break;
		    
	    	case 'oprCombo':
	    		return this.query('customcombobox#oprCombo')[0];
		    break;
		    
	    	case 'operandField':
	    		return this.query('field#operandField');
		    break;
		    
	    	case 'datefields':
	    		return this.query('datefield');
	    	break;
    	}
    	
    },
    
    /*
     * @method createSearchLineItemByModel
     * method to create the line structure which is initialized with model.
     * 
     * @param {object} searchCriteria
     */
    createSearchLineItemByModel: function(searchCriteria) {
    	var advancedSearchCriteria = searchCriteria.advancedSearchCriteria;
    	var operands = new Array();
    	operands = searchCriteria.advancedSearchCriteria.operands;
    	
    	this.initializeComponent();
    	
    	var tableCombo = this.getComponentById('tabCombo');
    	tableCombo.setValue(advancedSearchCriteria.searchConfigEntityId);
    	
    	var columnCombo = this.getComponentById('colCombo');
    	if(!isNullOrEmpty(advancedSearchCriteria.searchTableColumnId)){
    		columnCombo.setValue(advancedSearchCriteria.searchTableColumnId);
    	}
    	
    	var operatorCombo = this.getComponentById('oprCombo');
    	if(!isNullOrEmpty(advancedSearchCriteria.searchCriteriaOperatorId)){
    		operatorCombo.setValue(advancedSearchCriteria.searchCriteriaOperatorId);
    	}
    	
    	var operandComponentArray = this.getComponentById('operandField');
    	var i;
    	if(operandComponentArray.length == 0) {
    		operandComponentArray = this.getComponentById('datefields');
    	}
    	
    	for(i=0; i<operandComponentArray.length; i++) {
    		if(operands[i] != null || operands[i]!= undefined)
    			operandComponentArray[i].setValue(operands[i]);
    	}
    	
    	var hiddenFieldsArray=this.query("hidden");
		if(hiddenFieldsArray.length>0){
			for(var hiddenFieldCount=0;hiddenFieldCount<hiddenFieldsArray.length;hiddenFieldCount++){
				var hiddenfield=hiddenFieldsArray[hiddenFieldCount];
				if(!isNullOrEmpty(searchCriteria.visibility) && hiddenfield.itemId=="visibility"){
					hiddenfield.setValue(searchCriteria.visibility);
				}
				if(!isNullOrEmpty(searchCriteria.whetherEditable) && hiddenfield.itemId=="whetherEditable"){
					hiddenfield.setValue(searchCriteria.whetherEditable);
				}
			}
		}
    }
    
	
});
