/*
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.messaging.systemEventMessagingRuleEditor.systemEventMessagingRuleEditor', {
	extend : 'Ext.form.Panel',
	alias : 'widget.systemeventmessagingruleeditor',
	autoScroll: true,
	cls:'panelNoSpace',
	//cls: 'searchTabs',
	componentCls: 'searchTabComponent',
	
	//title: getCommonTranslation('ADVANCED_SEARCH'), //Twicking Part
	config : {
		searchConfigCode : null,
		searchResultViewCode: null,
		searchConfigDataSourceForMessaging :null
	},
	initComponent: function() {
		//this.loadConfiguration();
		this.callParent();
    },
    
    items : [{
			xtype: 'searchcriteriagroupformessaging',
			itemId: 'defaultGroupForMessaging',
			//disabled:true,
			minWidth: 800,
			config: {
				searchConfigDataSourceForMessaging: this.searchConfigDataSourceForMessaging
			}
		},
		/*{
			xtype: 'searchcriteriagroupformessaging',
			itemId: 'workingSearchCriteriaGroup',
			config: {
				searchConfigDataSourceForMessaging: this.searchConfigDataSourceForMessaging
			}
		},*/
		{
			xtype: 'toolbar',
			//border: 1,
			margin: '20 10 0 10',
			region: 'south',
			items: [/*{
				xtype: 'text',
				text: getCommonTranslation('ADVANCEDSEARCHLOADSAVEDSEARCHTEXT')
			},{
				xtype: 'customcombobox',
				valueField: 'id',
				displayField: 'searchName',
				store: 'Academia.store.criteriabuilder.SavedCriterias',
				itemId: 'loadSavedSearchComboId',
				listeners:{
					'render':function(comboReference){
						this.up('panel').updateComboURL(comboReference);
					},
	                'select': function(comboReference, records, eOpts) {
	                	this.up('panel').loadSavedSearchCriteria(this.up('panel'), records[0].getId());
	                }
				}
			}*/,{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'SaveSearchButtonForMessaging',
//				ui: 'CustomBtnSubmit',
				handler: function() {
					//this.up('panel').saveSearchCriteria();
				}
			},{
				xtype: 'button',
				text: getCommonTranslation('CLEARCRITERIA'),
//				ui: 'CustomBtnCancel',
				itemId: 'ClearCriteriaButtonForMessaging',
				handler: function() {
					this.up('panel').clearSearchCriteria(this.up('panel'));
					//this.up('panel').clearDependentFields(this.up('panel'));
				}
			},{
				xtype: 'button',
				formBind: true,
				text: getCommonTranslation('SEARCH'),
				hidden:true,	//This is twicking part for system event messaging rule editor
				itemId: 'searchButtonForMessaging',
				handler: function() {
					var advancedSearchRequest = this.up('panel').prepareSearchCriteria();
					this.up('panel').fireSearchAndPopulateGrid(advancedSearchRequest);
				}
			}]
		},{
			xtype: 'searchresultgrid',
			itemId: 'userAdvSearchResultGridForMessaging',
			hidden:true	//This is twicking part for system event messaging rule editor  
	}],
		
	/*
	 * this is called from the initcomponent of the same file
	 */
	loadConfiguration: function(qyeryBuilderView,cbSearchCriteria,whetherPassedDefaultSearchCriteriaToCMP,myMask) {
		var systemEventMessagingRuleEditor=this;
			
		var advancedSearchConfigStore = Ext.getStore('Academia.store.messaging.MessageSearchConfigs');
		//ADVANCEDSEARCHCONFIGSTOREURL: 'rest/cb/getSearchData?configCode=USER_LIST&viewCode=UserList',
		//advancedSearchConfigStore.getProxy().api.read
		var searchConfigDataUrl =SERVERURL.ADVANCEDSEARCHCONFIGSTOREURL;
		searchConfigDataUrl = searchConfigDataUrl.concat(this.searchConfigCode+'&viewCode='+this.searchResultViewCode);
		advancedSearchConfigStore.getProxy().api.read=searchConfigDataUrl;
		
		/*
		 * Use the config's and assign it to the store to load the respective search
		 */

			advancedSearchConfigStore.load({
			    scope: this,
			    callback: function(records, operation, success) {
			        this.buildSearchConfigDataSource(advancedSearchConfigStore);
			        			        
			        if(whetherPassedDefaultSearchCriteriaToCMP){
			        	var advancedSearchCriteria = Ext.create('Academia.model.criteriabuilder.AdvancedSearchCriteria', cbSearchCriteria);                 	
	                	var defaultGroupForMessaging = qyeryBuilderView.items.items[0];
	                	defaultGroupForMessaging.initializeByModel(advancedSearchCriteria);
			        }			        
                	
			        if(myMask){
			        	myMask.hide();
			        }
			        
                	/*if(systemEventMessagingRuleEditor){
                		var defaultSearchCriteriaGroup=systemEventMessagingRuleEditor.down("#defaultGroupForMessaging");
                		if(defaultSearchCriteriaGroup){
                			var groupButton=defaultSearchCriteriaGroup.down("#groupButton");
                			if(groupButton){
                				groupButton.fireEvent('click',groupButton);
                			}
                		}
                	}*/
			    }
			});
	
	},
	
	/*
	 * @method buildSearchConfigDataSource
	 * method to populate all the required/dependent stores for populating the dropdowns
	 * @param {object} advancedSearchConfigStore : the store object which will contain the server response
	 * which will bring the basic configuration of the criteria builder.
	 */
	buildSearchConfigDataSource:function(advancedSearchConfigStore){
		wsAdvancedSearchConfig = advancedSearchConfigStore.getAt(0);
		searchConfigDataSourceForMessaging =Ext.create('Academia.view.messaging.systemEventMessagingRuleEditor.SearchConfigDataSourceForMessaging', {
	    		wsSearchConfigTables : wsAdvancedSearchConfig.data.wsSearchConfigTables,
	    		/*
	    		 * did not initialize the columns, They will be initialized on selection of tables dropdown.
	    		 */
	    		dateOperators:wsAdvancedSearchConfig.data.searchCriteriaOperators.DATE,
	    		booleanOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.BOOLEAN,
	    		stringOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.STRING,
	    		integerOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.NUMBER,
	    		
	    		identityOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.IDENTITY,
	    		referenceIdentifyOperators :wsAdvancedSearchConfig.data.searchCriteriaOperators.REF_IDENTITY,
	    		enumOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.ENUM,
	    		characterOperators : wsAdvancedSearchConfig.data.searchCriteriaOperators.CHAR
		 	});
		 this.searchConfigDataSourceForMessaging = searchConfigDataSourceForMessaging;
	},

	/*
	 * @method
     * method to prepare the search criteria json object from the selected values.
     */
    prepareSearchCriteria: function() {
    	
    	var advancedSearchRequest = new Object();
    	var sortCriterias = new Array();
    	
    	//Fixed for user management Screen advanced search
    	//advancedSearchRequest.configCode= 'USER_LIST';
    	advancedSearchRequest.configCode= this.searchConfigCode;
    	
    	var sortCriteria = new Object();
    	sortCriteria.sortOrder = "ASC";
    	sortCriteria.searchResultViewColumnId = 5;
    	sortCriterias.push(sortCriteria);
    	
    	//TODO: remove hardcoding
    	var sortCriteria1 = new Object();
    	sortCriteria1.sortOrder = "DESC";
    	sortCriteria1.searchResultViewColumnId = 6;
    	sortCriterias.push(sortCriteria1);
    	var request = null;
    	try {
    		request = this.down('panel#defaultGroupForMessaging').getSearchCriteriaValue();
        }
        catch (ex) {
        	showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation('CANNOTPERFORMSEARCHONEMPTYGROUP'));
        	Ext.Error.notify = false;
    		Ext.Error.ignore = true;
            Ext.Error.raise(getErrorTranslation('CANNOTPERFORMSEARCHONEMPTYGROUP'));
            return false;
        }
    	
    	//advancedSearchRequest.sortCriterias = sortCriterias;
    	advancedSearchRequest.cbSearchCriteria = request;
    	
    	
    	return advancedSearchRequest;
    	/*submitUrl = SERVERURL.SEARCHREQUESTURL;
    	//Add grid to the view
    	var resultGrid = this.down("#userAdvSearchResultGridForMessaging");
    	resultGrid.initialize(submitUrl,AdvancedSearchRequest);*/
    },
    
    /*
     * @method
     * method for populating the grid with result after the click of search button.
     * @param {object} which is the json that is prepared by prepareSearchCriteria method.  
     */
    fireSearchAndPopulateGrid: function(AdvancedSearchRequest){
    	submitUrl = SERVERURL.SEARCHREQUESTURL;
    	var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	resultViewUrl = resultViewUrl.concat(this.searchResultViewCode);
    	//Add grid to the view
    	var resultGrid = this.down("#userAdvSearchResultGridForMessaging");
    	resultGrid.initialize(submitUrl, resultViewUrl, AdvancedSearchRequest);
    },
    
    /*
     * @method method for clearing the existing components in the search criteria panel.
     * 
     */
    clearSearchCriteria: function(advancedSearchQueryBuilderView) {
    	var containerPanel = advancedSearchQueryBuilderView.down('panel#verticalPanel').items;
    	if(containerPanel.items.length > 0) {
    		Ext.each(containerPanel.items, function(obj) {
        		if(obj != undefined) {
        			obj.close();	
        		}
    		});
    		if(containerPanel.items[0] != undefined)
        	containerPanel.items[0].close();
    	}
    },
    
    /*
     * @method 
     * method for loading the previously saved search criteria onto the screen.
     * @param {object} advancedSearchQueryBuilderView : is the reference of the view.
     * @param {integer} savedCriteriaId : is the id of the selected search.
     */
    loadSavedSearchCriteria: function(advancedSearchQueryBuilderView, savedCriteriaId) {
    	
    	/*
    	 * called the method for deleting the previously added components.
    	 */ 
    	this.clearSearchCriteria(advancedSearchQueryBuilderView);
    	
    	var qyeryBuilderView = advancedSearchQueryBuilderView;
    	var submitUrl = SERVERURL.LOADSAVEDSEARCHURL;
    	submitUrl= submitUrl.concat(savedCriteriaId);
    	Ext.Ajax.request({
            url: submitUrl,
            method: 'GET',
            success: function(response) {
            	var responceData = JSON.parse(response.responseText);
            	var advancedSearchCriteria = Ext.create('Academia.model.criteriabuilder.AdvancedSearchCriteria', responceData.cbSearchCriteria); 
            	
            	var defaultGroupForMessaging = qyeryBuilderView.items.items[0];
            	defaultGroupForMessaging.initializeByModel(advancedSearchCriteria);
            }
        });
        advancedSearchQueryBuilderView.down('button#searchButtonForMessaging').enable();
    },
    
    getSearchCriteriaJsonObject:function(){
    	var queryBuilderViewRef = this;    	
    	var advancedSearchRequest = queryBuilderViewRef.prepareSearchCriteria();
    	return advancedSearchRequest;
    }, 
    /*
     * @method
     * method to save the search criteria on click of the save button.
     */
    saveSearchCriteria: function(){	
    	var queryBuilderViewRef = this;
    	Ext.Msg.prompt(getCommonTranslation('ADVANCEDSEARCHSAVEOPPUP'), getCommonTranslation('ADVANCEDSEARCHSAVEMESSAGE'), function(btn, text){
    	    if (btn == 'ok'){
    	    	var advancedSearchRequest = queryBuilderViewRef.prepareSearchCriteria();
    	    	var submitUrl =SERVERURL.SAVESEARCHCRITERIAURL;
    	    	var sortCriterias = new Array();
    	    	// TODO remove hardcoded userid Use from context
    	    	var userid=1;
    	    	submitUrl = submitUrl.concat('?name='+text+'&viewCode='+queryBuilderViewRef.searchResultViewCode+'&userid='+userid);
    	    	var sortingToolbar =queryBuilderViewRef.down('grid').query('multiSortToolbar')[0];
    	    	/*var toolbarItems = sortingToolbar.getSorters();
    	    	Ext.each(toolbarItems, function(key, value, myself) {
    	    		sortCriterias.push(key);
    	    	});*/
    	    	advancedSearchRequest.sortCriterias = sortCriterias;
    	    	Ext.Ajax.request({
    	            type: 'rest',
    	            url: submitUrl,
    	            jsonData: advancedSearchRequest,
    	            method: 'POST',
    	            success: function(form, action) {
    	                showSuccessMessage(getCommonTranslation('ADVANCEDSEARCHSAVEOPPUP') , getCommonTranslation('SUCCESS'));
    	                queryBuilderViewRef.loadSavedSearchCombo(form);
    	            },
    	            failure: function(form, action) {
    	            	showErrorMessage(getCommonTranslation('ADVANCEDSEARCHSAVEOPPUP'), getCommonTranslation('FAILURE'));
    	            }
    	        });
    	    	 queryBuilderViewRef.loadSavedSearchCombo();
    	    }
    	});
    	
    	
    },
    
    loadSavedSearchCombo: function() {
    	this.down('customcombobox#loadSavedSearchComboId').getStore().load();
    },
    
    clearDependentFields: function(queryBuilderViewRef) {
    	queryBuilderViewRef.down('#loadSavedSearchComboId').clearValue();
    	queryBuilderViewRef.down('button#searchButtonForMessaging').disable();
    },
    updateComboURL:function(comboReference){
    	var savedSearchStore=comboReference.getStore();
    	var savedSearchUrl=SERVERURL.SAVEDCRITERIASCOMBOURL;
    	// TODO remove hardcoded userid Use from context
    	var userid=1; 
    	savedSearchUrl=savedSearchUrl.concat(userid+"&configCode="+this.searchConfigCode);
    	savedSearchStore.getProxy().api.read=savedSearchUrl;
    }
    
	
});