/**
 * @author Akshay.Kalbhor
 * 
 * This component is used for to show Academy Location Purpose Details in grid.
 */
Ext.define('Academia.view.organization.academylocations.AcademyLocationPurposeGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.academylocationpurposegrid',
			requires: ['Academia.view.organization.academylocations.AcademyLocationPurposeFormWindow'],
			store : 'organization.academylocations.AcademyLocationPurposeStore',
			title : getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),//Academy-Location Purposes
			border: true,
			cls: 'centerAlignTitle parallelGridCenterAlignTitle',
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'academylocation':1
				}
			},
			columns : [ {
				header : getCommonTranslation('PURPOSE'),//Purpose	
				dataIndex : 'purpose',
				sortable : true,
				flex:3,
				renderer :function(value){
					return getCommonTranslation(value);
				}
			}, {
				header : getCommonTranslation('START_DATE'),//Start Date
				dataIndex : 'startDate',	
				sortable : true,
				flex:2,
				renderer:function(date){         
		        	return dateRender(date);
		        }
			},{
				header : getCommonTranslation('END_DATE'),//End Date
				dataIndex : 'tillDate',	
				sortable : true,			
				flex:2,
				renderer:function(date){         
					return dateRender(date);
				}
			},{
				header : getCommonTranslation('NO_OF_DOCUMENT'),
				dataIndex : 'numberOfDocuments',
				flex : 1,
				renderer:function(value){
					if(value>0){
						return  '<a href="#">'+value+'</a>';
					}else{
						return value;
					}
				}
			}],
			tbar : [ {
				xtype : 'button',				
				itemId : 'btnAdd',
				tooltip : getCommonTranslation('ADD'),//Add
				glyph: ICONGLYPH.ADDGLYPH
				//text : getCommonTranslation('ADD')
			},{
				xtype : 'button',				
				itemId : 'btnEdit',
				tooltip : getCommonTranslation('EDIT'),//Edit
				glyph: ICONGLYPH.EDITGLYPH
				//text : getCommonTranslation('EDIT')
			},{
				xtype : 'button',				
				itemId : 'btnView',
				tooltip : getCommonTranslation('VIEW'),//View
				iconCls: 'view-icon'
				//text : getCommonTranslation('VIEW')
			},{
				xtype : 'button',				
				itemId : 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),//Delete
				glyph: ICONGLYPH.DELETEGLYPH
				//text : getCommonTranslation('DELETE')
			},{
				xtype : 'splitbutton',
				itemId:'spBtnMoreActions',
				text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
				menu:[{
					text:getCommonTranslation('UPLOAD_DOC'),
					itemId:'purposeuploadDoc'
				}],
				 listeners: { click: function() { this.showMenu(); } }
			}],
			dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'organization.academylocations.AcademyLocationPurposeStore',
					emptyMsg : '<span id="ALPurposeGridId" style="margin-top: 60px !important">'+getCommonTranslation('EMPTY_ACADEMY_LOCATION_PURPOSE_MSG')+'</span>',//No academy location purposes to display
					displayInfo : true
				}]
			} ],
			showAcademyLocationPurposeForm: function() {				
				var winAcademyLocationPurposeForm=Ext.widget('academylocationpurposeformwindow');
				winAcademyLocationPurposeForm.show();					
			}
		});