/**
 * this window is used to show the quota type popup on the quotas grid.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.organization.academylocations.AddLogoWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.addlogowindow',
    modal: true,
    resizable: false,
    width: 450,
    title: getCommonTranslation('ACADEMY_LOCATION_LOGO'), // quota Details
    layout: 'vbox',
    defaults: {
    	width: '100%'
    },
    items: [{
        xtype: 'form',
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype : 'hidden',
        	name: 'id',
        	itemId: 'academyLocationId'
        },{
        	xtype : 'hidden',
        	name: 'existingFilePath',
        	itemId: 'existingFilePath'
        },{
            xtype: 'textfield',
            name: 'code',
            itemId: 'academyLocDisplayName',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION_DISPLAY_NAME'),
            editable: false,
            readOnly: true
        }, {
        	xtype: 'photouploadform',
        	itemId: 'logoUploadField',
        	width: 275
            /*name: 'photo',
            fieldLabel: getCommonTranslation('SELECT_LOGO'),
            labelWidth: 50,
            //msgTarget: 'side',
            allowBlank: false,
            //anchor: '100%',
            buttonText: getCommonTranslation('SELECT_PHOTO')*/
        }, {
        	xtype:'image',
            itemId: 'organizationLogo',
            border: 1,
            style: {
                borderColor: 'black',
                borderStyle: 'solid'
            },
            width: 130,
            height: 150
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveLogo',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancel',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                	click: function() {
                		this.up('window').close();
                	}
                }
            }]
        }]
    }]

});