/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show location and address details in Dialog box
 */	   
Ext.define('Academia.view.organization.locations.LocationFormWindow',{
			extend : 'Ext.window.Window',
			alias : 'widget.locationformwindow',			
			modal : true,
			resizable:false,
			title : getCommonTranslation('LOCATION'),//Location
			overflowY:'auto',
			//autoScroll:true,
			height:700,
			items : [{
				xtype: 'idgeneratorcustomform',
				plugins : "formlabelrequired",
				itemId:'locationAddressCombinedForm',	
				customFieldEntity:CONSTANTS.ADDRESS_CF_DATA,
			    customFieldEntityType:CONSTANTS.ADDRESS_CF_DISPLAY_NAME,
			    bodyPadding: '0 20 0 0',
			    standardSubmit: false,	
			    cls:'academyLocationWinCls',
			    title: getCommonTranslation('LOCATION_DETAILS'),
			    defaults: {
			        labelAlign: 'top',
			        width: 256,
			        enforceMaxLength : true,
			    },
			    items : [/*{   //chagnes as per V2D-389578
					xtype : 'LocationForm',
					itemId:'locationfieldsfrm',
					frame:true,
					width: 'auto'
				}, {
					xtype : 'addressfieldsform',
					itemId:'addressfieldsfrm',
					plugins: "formlabelrequired",
					title : getCommonTranslation('LOCATION_ADDRESS'),//Location Address
					frame:true,
					width: 'auto'
				},*/
			    	/*Location form Fields starting from here (chagnes as per V2D-389578)*/
			    	{
			            xtype: 'hidden',
			            name: 'id'
			        }, {
			            xtype: 'hidden',
			            name: 'organizationId'
			        },{
			        	xtype : 'hidden',
			    		name : 'version'
			        }, 
			      //TODO:When Short Codes of Master Data get completed then show configured location short code with data 
			        
			        {
			            xtype: 'fieldcontainer',
			            width: 'auto',
			            layout: {
			                type: 'hbox'
			            },
			            defaults: {
			                labelAlign: 'top',
			                width: 256
			            },
			            items: [{
				    		xtype : 'textfield',
				    		name : 'locationCode',		
				    		fieldLabel : getCommonTranslation('LOCATION_CODE_SHORT'),  //Short Code
				    		allowBlank: false,
				    		enforceMaxLength:true,
				            maxLength:10
				    	},{
				    		xtype : 'textfield',
				    		name : 'name',
				    		fieldLabel : getCommonTranslation('LOCATION'), //Location
				    		allowBlank: false		
				    	},{
			                xtype: 'datefield',
			                name: 'startDate',
			                fieldLabel: getCommonTranslation('START_DATE'), //Start Date
			                vtype: 'daterange',
			                itemId: 'startDate',
			                endDateField: 'tillDate',
			                editable: true,
			                allowBlank: false,
			              //--submitFormat: CONSTANTS.DATE_FORMAT,
			                listeners: {
			                	render: function(field) {
			                		return dateFormatRender(field);
			                	}
			                }
			            }]
			        },{
			            xtype: 'fieldcontainer',
			            width: 'auto',
			            layout: {
			                type: 'hbox'
			            },
			            defaults: {
			                labelAlign: 'top',
			                width: 256
			            },
			            items: [{
			                xtype: 'datefield',
			                name: 'tillDate',
			                itemId: 'tillDate',
			                vtype: 'daterange',
			                startDateField: 'startDate',
			                fieldLabel: getCommonTranslation('END_DATE'), //End Date
			                editable: true,
			              //--submitFormat: CONSTANTS.DATE_FORMAT,
			                listeners: {
			                	render: function(field) {
			                		return dateFormatRender(field);
			                	}
			                }
			            },{
			            xtype: 'statusCombo',
			            editable: false,
			            allowBlank: false,
			            name: 'status',
			            itemId:'status'
			        },{
			    		xtype : 'textfield',
			    		name : 'otherLanguageName',
			    		maskRe: /^[a-zA-Z0-9\s]+$/,
			    		itemId:'otherLanguageName',
			    		maxLength:255,
			    		enforceMaxLength:true,
			    		listeners : {
			                change : function(field, newValue,oldValue) {
			                    var validation=/^[a-zA-Z0-9\s]+$/;
			                    if(!validation.test(newValue) && newValue!='' ) {
			                        field.setValue(oldValue);
			                    }
			                }
			            },
			    		fieldLabel : getCommonTranslation('DISPLAY_NAME_IN_OTHER_LANGUAGE')
			    	}]
			        }, 
			    	/*Address form Fields starting from here (chagnes as per V2D-389578)*/
			    	{
			    		xtype: 'fieldcontainer',
			    		itemId: 'topFieldContainer',
			    		layout: {
			    			type: 'hbox'
			    	    },
			    	    width:450
			    	},{
			        		xtype : 'hidden',
			        		name : 'addressPrimaryId',
			        		itemId:'addressPrimaryId',
			            },{
			            	xtype : 'hidden',
			        		name : 'addressVersion',
			        		itemId:'addressVersion',
			            },{
			    		xtype : 'customcombobox',
			    		fieldLabel : getCommonTranslation('ADDRESS_TYPE'),
			    		name : 'addressType',
			    		itemId : 'addressTypeId',
			    		store:'organization.AddressTypeStore', 
			    		valueField : 'id',
			    		displayField : 'addressTypeName',
			    		editable : false,
			    		hidden:true
			    	}, {
			    		xtype : 'textareafield',
			    		fieldLabel : getCommonTranslation('ADDRESS'),
			    		name : 'addressText',
			    		itemId : 'addressText',
			    		//vtype: 'NospaceAsInput',
			    		allowBlank:false,
			    		width: 700,
			    		listener:{
			    			blur:function(){}
			    		}
			    	}, {
			    		xtype : 'textareafield',
			    		fieldLabel : getCommonTranslation('ADDRESS_OTHER_LANGUAGE'),
			    		name : 'addressTextOtherLanguage',
			    		itemId : 'addressOtherLanguageId',
			    		width: 536,
			    		hidden:true,
			    		listener:{
			    			blur:function(){}
			    		}
			    	},{
			    	    xtype: 'fieldcontainer',
			    	    width: 'auto',
			    	    defaults: {
			    	    	labelAlign: 'top',
			    	    	width: 256
			    	    },
			    	    layout: {
			    		type: 'hbox'
			    	    },
			    	    items: [{
			            		xtype : 'customcombobox',
			            		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
			            		hiddenName : 'country',
			            		itemId : 'countryId',
			            		store:'common.CountryStore',
			            		valueField : 'id',
			            		displayField : 'countryName',
			            		name : 'country',
			            		//editable : false,
			            		//valueNotFoundText:"",     
			        			queryParam:'countryName',   		        						
			    				forceSelection :true,
			    				allowBlank:false,
			    				typeAhead : false,
			    				minChars:3,
			    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    				hideTrigger:false,
			    				listConfig: {
			    					  listeners: {
			    							beforeshow: function(picker) {
			    								picker.minWidth = picker.up('combobox').getSize().width;
			    							}
			    						},
			    		                loadingText: getCommonTranslation('SEARCHING'),
			    		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    		                getInnerTpl: function() {
			    		                    return '<div class="search-item">' +
			    		                    '{countryName}'  +
			    		                    '</div>';
			    		                }
			    		            }
			            	},{
			            		xtype : 'customcombobox',
			            		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
//			            		name : 'genericField1',
			            		itemId : 'parentCountryRegionId',
			            		store:'organization.CountryRegionStore',
			            		valueField : 'id',
			            		displayField : 'countryRegionName',
			            		name : 'parentCountryRegion',
			        			queryParam:'regionName',   		 
			            		//editable : false,
			            		//valueNotFoundText:"",        		        						
			    				forceSelection :true,
			    				allowBlank:false,
			    				typeAhead : false,
			    				hideTrigger:false,
			    				minChars:3,
			    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    				listConfig: {
			    					  listeners: {
			    							beforeshow: function(picker) {
			    								picker.minWidth = picker.up('combobox').getSize().width;
			    							}
			    						},
			    		                loadingText: getCommonTranslation('SEARCHING'),
			    		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    		                getInnerTpl: function() {
			    		                    return '<div class="search-item">' +
			    		                    '{countryRegionName}'  +
			    		                    '</div>';
			    		                }
			    		            }
			            	},{
			        		xtype : 'customcombobox',
			        		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
			        		hiddenName : 'city',
			        		itemId : 'cityId',
//			        		store:'organization.CityStore',
			        		store:'organization.CityByCountryRegion',
			        		valueField : 'id',
//			        		displayField : 'cityName',
			        		displayField : 'value',
			        		name : 'city',
			    			queryParam: 'searchText',   		 
			        		//editable : false,    
			        		//valueNotFoundText:"",        		
			    			forceSelection :true,
			    			allowBlank:false,
			    			typeAhead : false,
			    			minChars:3,
			    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    			listConfig: {
			    				  listeners: {
			    						beforeshow: function(picker) {
			    							picker.minWidth = picker.up('combobox').getSize().width;
			    						}
			    					},
			    	                loadingText: getCommonTranslation('SEARCHING'),
			    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    	                getInnerTpl: function() {
			    	                    return '<div class="search-item">' +
			    	                    '{value}'  +
			    	                    '</div>';
			    	                }
			    	            }
			        	}]
			    	}, {
			    	    xtype: 'fieldcontainer',
			    	    width: 'auto',
			    	    defaults: {
			    	    	labelAlign: 'top',
			    	    	width: 256
			    	    },
			    	    layout: {
			    		type: 'hbox'
			    	    },
			    	    items: [{
			        		xtype : 'textfield',
			        		fieldLabel : getCommonTranslation('PINCODE'),
//			        		hiddenName : 'pincode',
			        		itemId : 'pincodeId',
			        		name : 'pincode',
			        		minValue : 0,
			        		maxLength: 8,
			        		maskRe:/^[a-zA-Z0-9\s]+$/,
			          	    /*mouseWheelEnabled :false,
			          	    hideTrigger :true,
			          	    allowExponential:false,
			          	    allowDecimals:false,*/
//			    			allowBlank:false
			        	},{
			    		    xtype: 'fieldcontainer',
			    		    width: 'auto',
			    		    fieldLabel : getCommonTranslation('GEOGRAPHICAL_AREA'),
			    		    itemId : 'geographicalAreaContainer',
			    			name : 'geographicalAreaContainer',  	
			    		    defaults: {
			    		    	labelAlign: 'top',
			    		    	width: 256
			    		    },
			    		    layout: {
			    			type: 'hbox'
			    		    },
			    		    items: [{
			    	    		xtype : 'textfield',
			    	    		hiddenName : 'Latitude',
			    	    		itemId : 'latitudeItemId',
			    	    		name : 'latitude',  		        		
			    				emptyText: getCommonTranslation('LATITUDE')
			    	    	},{
			    	    		xtype : 'textfield',
			    	    		hiddenName : 'Longitude',
			    	     		itemId : 'longitude',
			    	    		name : 'longitude',
			    	    		emptyText: getCommonTranslation('LONGITUDE')
			    	    	}]
			    		    }]
			    	    },{
			    		
			    		xtype: 'fieldcontainer',
			    	    width: '100%',
			    		fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
			    		//allowBlank:false,
			    		itemId:'addressPhoneFieldContainerId',
			    		layout : {
			    			type : 'hbox'
			    		},
			    		defaults: {
			    			enforceMaxLength : true,
			    			labelAlign: 'top',
			    			width: 256
			    			//cls:'inputInRow'
			    		},
			    		items : [ {
			    			xtype : 'customcombobox',
			    			hiddenName : 'phoneNumber1',
			    			valueField : 'isdCode',
			    			displayField : 'isdCode',
			    			store:'common.CountryStore',
			    			queryMode: 'local',
			    			triggerAction : 'all',
			    			name : 'phoneCountryCode',
			    			itemId : 'phoneCountryCode',
			    			editable : false,			
			    			width: 108,
			    			emptyText:getCommonTranslation('ISD')
			    		}, {
			    			xtype : 'textfield',
			    			name : 'AreaCode',
			    			name : 'phoneAreaCode',
			    			width: 108,
			    			maxLength: 5,
			    			maskRe:/\d/,
			    			   itemId : 'phoneAreaCode',
			    			   margin:'0 0 0 -25',
			    			   height:36,
			    		        emptyText:getCommonTranslation('STD')
			    		}, {
			    			xtype : 'numberfield',
			    			itemId : 'phoneNoField',
			    			name : 'phoneNo',
			    		    hideTrigger: true,
			    	        keyNavEnabled: false,
			    	        mouseWheelEnabled: false,
			    	        allowExponential:false,
			    	        maxLength: 10,
			    	        margin:'0 0 0 -50',
			    	        emptyText:getCommonTranslation('ADDRESS_PHONE_NUMBER_1')
			    		} ]
			    	}, {
			    	    	xtype: 'fieldcontainer',
			    		    width: '100%',
			    	    	itemId:'addressCellFieldContainerId',
			    		    fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
			    	    	defaults: {
			    			enforceMaxLength : true,
			    			labelAlign: 'top',
			    			width: 256
			    		},
			    		layout : {
			    			type : 'hbox'
			    		},
			    		items : [ {
			    			xtype : 'customcombobox',
			    			name : 'cellCountryCode',
			    			itemId : 'cellCountryCode',
			    			valueField : 'isdCode',
			    			displayField : 'isdCode',
			    			store:'common.CountryStore',
			    			queryMode: 'local',
			    			triggerAction : 'all',
			    			editable : false,
			    			width: 108,
			    			emptyText:getCommonTranslation('ISD')
			    		}, {
			    			xtype : 'numberfield',
			    			name : 'cellNo',
			    			itemId : 'cellNo',
			    			minLength: 0,
			    			maxLength: 15,
			    			// To Remove spinner buttons, and arrow key and mouse wheel listeners
			    	        hideTrigger: true,
			    	        keyNavEnabled: false,
			    	        mouseWheelEnabled: false,
			    	        allowExponential:false,
			    	        margin:'0 0 0 -25',
			    	        emptyText:getCommonTranslation('ADDRESS_MOBILE_NO')
			    		} ]
			    		// V2D-98400
//			    	}] 
			    	}, {
			    		xtype: 'fieldcontainer',
			    	    width: 'auto',
			    	    defaults: {
			    	    	labelAlign: 'top',
			    	    	width: 256
			    	    },
			    	    layout: {
			    		type: 'hbox'
			    	    },
			    	    items: [{
			    	    	xtype : 'textfield',
			    	    	fieldLabel : getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),
			    	    	name : 'primaryeEmailId',
			    	    	vtype: 'email',
			    	    	itemId : 'primaryeEmailId',
			    	    	maxLength: 100
//			    	    	allowBlank: false
			    	    }, {
			    	    	xtype : 'textfield',
			    	    	fieldLabel : getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),
			    	    	name : 'alternateEmailId',
			    	    	vtype: 'email',
			    	    	allowBlank: true,
			    	    	itemId : 'alternateEmailId',
			    	    	maxLength: 100
			    	    },{
			        		xtype : 'textfield',
			        		fieldLabel : getCommonTranslation('FAX_NUMBER'),
			                itemId : 'faxNumberId',
			        		name : 'faxNumber',
			        		minValue : 0,
			        		maxLength: 25,
			        		
			        	},{
			    	    	xtype: 'textfield',
			    	    	fieldLabel: getCommonTranslation('ALA_WEBSITE_URL'),
			    	    	name: 'websiteURL',
			    	    	itemId: 'websiteURLItemId',
			    	    	regex:/^(https?:\/\/)?(www\.)?([-a-z0-9]{1,63}\.)*?[a-z0-9][-a-z0-9]{0,61}[a-z0-9]\.[a-z]{2,6}(\/[-\w@\+\.~#\?&\/=%]*)?$/i,
			    	    	regexText :'Website URL format should be http://www.eg.com or www.eg.com or eg.com',
			    	    	hidden: true
			    	    }]
			    	},
			    	{
			            xtype: 'multiselectcombofield',
			            name: 'otherAddressTypeId',
			            itemId: 'otherAddressTypeItemId',
			            autoloadStore: false,
			            width: 536,
			            fieldLabel: getCommonTranslation('COPY_THIS_ADDRESS_TO'),
			            //store:'common.OtherAddressCopyStore',
			            valueField: 'id',
			            displayField: 'addressTypeName',
			            //queryParam: 'qry',
			            typeAhead: true,
			            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
			            enableKeyEvents: 'true',
			            hideTrigger: false,
			            forceSelection: true,
			            hidden: true,
			    		listeners  :{
			    			render : function(combo){
			    				var store=Ext.create('Academia.store.common.OtherAddressCopyStore');
			    				combo.bindStore(store);
			    			}
			    		},
			            listConfig: {
			                listeners: {
			                    beforeshow: function(picker) {
			                        picker.minWidth = picker.up('combobox').getSize().width;
			                    }
			                },
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                        '{code}' +
			                        '</div>';
			                }
			            }
			        },
			        /*Address form Fields ending from here */
			    	/*{
			    	xtype : 'hidden',
					name : 'version'
			    }*/,{
		        	xtype:'fieldcontainer',
		        	width:'100%',
		        	cls:'windowBtnPos',
		            items: [{
						xtype : 'button',				
						itemId : 'saveLocationButtonId',				
						text : getCommonTranslation('SAVE'), //Save
						ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind:true
					},{
						xtype : 'button',
						itemId:'btnCancelLocationForm',						
						text : getCommonTranslation('CANCEL'), //Cancel
						ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
					}]
				}]
			}]			
		});