Ext.define('Academia.view.organization.sasaumaumapping.UnAllocatedALPGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.unallocatedalpgrid',
    flex: 1,
    hidden: true,
    title: getCommonTranslation('UNALLOCATED_ALP_GRID_TITLE'),
    store: 'organization.susaumapping.UnallocatedALPStore',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [/*{
        hidden: true,
        dataIndex: 'organizationSupervisoryUnitId'
    }, {
        hidden: true,
        dataIndex: 'alpId'
    },*/ {
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academy.academyName',
        flex: 0.2
    }, {
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'location.name',
        flex: 0.2
    }, {
        header: getCommonTranslation('PURPOSE'),
        dataIndex: 'purpose',
        flex: 0.2
    }, {
        header: getCommonTranslation('START_DATE'),
        dataIndex: 'startDate',
        xtype: 'datecolumn',
        allowBlank: false,
        itemId:'startDateColumn',
        //format: 'd-m-Y',
        flex: 0.1,
        editor: {
            xtype: 'datefield',
            allowBlank: false,
            itemId:'startDate',
          //--submitFormat: 'd-m-Y',
            submitValue: true,
            listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },
		renderer:function(date) {
			return dateRender(date);
		}

    }, {
        header: getCommonTranslation('END_DATE'),
        dataIndex: 'tillDate',
        xtype: 'datecolumn',
        itemId:'tillDateColumn',
       // format: 'd-m-Y',
        flex: 0.1,
        editor: {
            xtype: 'datefield',
            itemId:'tillDate',
            allowBlank: false,
          //--submitFormat: 'd-m-Y',
            submitValue: true,
            listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        xtype: 'actioncolumn',
        header: getCommonTranslation('LINK'),
        icon: 'resources/images/link2.png',
        flex: 0.2,
        tooltip: getCommonTranslation('LINK'),
        itemId: 'unallocatedGridActionColumnId'
    }],
    dockedItems : [ {
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
	        displayInfo: true,
	        store: 'organization.susaumapping.UnallocatedALPStore'
    	 }]
    }],
    
    plugins: [

    Ext.create('Ext.grid.plugin.CellEditing', {
        clicksToEdit: 1
    })]


});