/*
 * This file is for the grid displayed in the popup which contains the linked ALP's
 */
Ext.define('Academia.view.organization.statutoryAccounting.LinkedALPGridSA', {
    extend: 'Ext.form.Panel',
    alias: 'widget.linkedalpgridsa',
    title: getCommonTranslation('LINKEDALPTITLE'),
    frame: true,
    items:[{
	xtype: 'grid',
	store: 'organization.AllocatedALPs',
	columns: [{
	    header: getCommonTranslation('ACADEMY'),
	    dataIndex: 'academy.academyName',
	    flex: 0.2
	}, {
	    header: getCommonTranslation('LOCATION'),
	    dataIndex: 'location.name',
	    flex: 0.2
	}, {
	    header: getCommonTranslation('PURPOSE'),
	    dataIndex: 'purpose',
	    flex: 0.2
	}, {
	    header: getCommonTranslation('OWNER'),
	    dataIndex: 'owner',
	    flex: 0.2
	},{
	    header: getCommonTranslation('END_DATE'),
	    dataIndex: 'tillDate',
	    xtype: 'datecolumn',
	    dateFormat: 'd-m-Y',
	    flex: 0.2,
		renderer:function(date) {
			return dateRender(date);
		}
	}],
	dockedItems: [{
		xtype: 'custompagingtoolbar',
        plugins:['pagesize'],
	    dock: 'bottom',
	    displayInfo: true,
	    store: 'organization.AllocatedALPs'
	}]
    }]
});