/**
 * @author trupti.paoneker
 * 
 * This component is used for to show contact person details in grid  
 */
Ext.define('Academia.view.othermasters.bankmaster.AddNewContactPersonGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.contactpersongrid',
    store: 'othermasters.bankmaster.AddNewContactPersonStore',
    title: getCommonTranslation('BANK_CONTACT_PERSON'), // Bank Master
    collapsible: false,
    //autoScroll: true,
    border: true,
    style:{'z-index':'9999'},
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'bankmaster':1
		}
	},
    columns: [{
        header: getCommonTranslation('PERSON_NAME'), //Person name
        dataIndex: 'personName',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('DESIGNATION'), //Designation
        dataIndex: 'designation',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('ADDRESS'), //Address
        dataIndex: 'address',
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, "addressText");
        }

    }, {
        header: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'), //Phone No.1
        dataIndex: 'address',
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, "phoneNo");
        }
    }, {
        header: getCommonTranslation('ADDRESS_MOBILE_NO'), //Phone No.2
        dataIndex: 'address',
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, "cellNo");
        }
    }, {
        header: getCommonTranslation('ADDRESS_PRIMARY_EMAIL'), //Email Id 1
        dataIndex: 'address',
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, "primaryeEmailId");
        }
    }, {
        header: getCommonTranslation('ADDRESS_SECONDARY_EMAIL'), //Email Id 2
        dataIndex: 'address',
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, "alternateEmailId");
        }
    }],

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'othermasters.bankmaster.AddNewContactPersonStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    showContactPersonDetailsForm: function() {
        var winAddressDetailsForm = Ext.widget('contactpersonformwindow');
        winAddressDetailsForm.show();
    }

});
