
Ext.define('Academia.view.othermasters.communitymaster.CommunityMasterFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.communitymasterfilter',
	cls: 'customSearchInnerPanel',
	initComponent:function(){
		 this.items= [{
			        xtype: 'fieldcontainer',
			        layout: {
			            type: 'hbox'
			        },
			        items: [{
		            	xtype : 'customcombobox',
						name : 'academyLocation',						
						fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),//Academy
			            labelAlign:'top',						
						itemId:'academyLocationComboField',
						valueField : 'id',
						width: 536,
						displayField : 'value',
						store:Ext.create('Academia.store.organization.academylocations.AcademyLocationSearchStore'),
						emptyText:getCommonTranslation('SELECT_ACADEMY'),//Select a academy
						queryParam:'nameOrCode',
					       minChars:3,
					        typeAhead:false,
					        hideTrigger:false,
					        forceSelection :true,
					        //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					        //triggerAction: '',
					        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					        listConfig: {
					        	listeners: {
					        		beforeshow: function(picker) {
					        			picker.minWidth = picker.up('combobox').getSize().width;
					        		}
					        	},
					        	loadingText: getCommonTranslation('SEARCHING'),
					        	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					        	getInnerTpl: function() {
					        		return '<div class="search-item">' +
					        		'{value}' +
					        		'</div>';
					        	}


					        }
		            }]},
		            {
				        xtype: 'fieldcontainer',
				        layout: {
				            type: 'hbox'
				        },
				        items: [{
				        	xtype : 'customcombobox',
				            name: 'program',
				            itemId: 'programCombo',
				            displayField: 'valueCode',
				            valueField: 'id',
				            width: 256,
				            disabled : true,
				            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				            labelAlign:'top',
				            emptyText:getCommonTranslation('SELECT_ACADEMY'),//Select a academy
							queryParam:'qry',
						       minChars:3,
						        typeAhead:false,
						        hideTrigger:false,
						        forceSelection :true,
						        //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
						        //triggerAction: '',
						        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						        listConfig: {
						        	listeners: {
						        		beforeshow: function(picker) {
						        			picker.minWidth = picker.up('combobox').getSize().width;
						        		}
						        	},
						        	loadingText: getCommonTranslation('SEARCHING'),
						        	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						        	getInnerTpl: function() {
						        		return '<div class="search-item">' +
						        		 + '{Code/}' +'{value}'+
						        		'</div>';
						        	}
						        }
				        }, {
				        	xtype : 'customcombobox',
				            name: 'batch',
				            itemId: 'batchCombo',
				            displayField: 'value',
				            width: 256,
				            labelAlign:'top',
				            valueField: 'id',
				            editable:false,
				            disabled : true,
				            fieldLabel: getCommonTranslation('BATCH'),
				            
				        }, {
				        	xtype : 'customcombobox',
				            name: 'seatType',
				            itemId: 'seatTypeCombo',
				            width: 256,
				            displayField: 'seatTypeName',
				            valueField: 'seatTypeId',
				            labelAlign:'top',
				            editable:false,
				            disabled : true,
				            progBatchSeatConfigId: null,
				            fieldLabel: getCommonTranslation('SEAT_TYPE'),
				           
				        }],
				        
						/**
						 * function to clear the combo store, clear its existing value
						 *  and remove all the records from the store.
						 *  @param {Object} the reference of the combo whose store should be cleared.
						 */
						clearCombo: function(combo) {
							combo.clearValue();
				    		combo.store.removeAll();
							}
		            }],

	        this.callParent(arguments);
	},
	
});