/**
 * @author Amit G
 * 
 * This component is used for to show window with new currency master details. 
 */
Ext.define('Academia.view.othermasters.currencymaster.AssociateInvoiceCurrencyFormSetUpWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.associateinvoicecurrencyformsetupwindow',
    modal: true,
    frame: true,
    resizable: false,
    autoScroll: true,
    height: '40%',
    title: getCommonTranslation('ASSOCIATE_BILLING_AND_RECEIPT_CURRENCY'), //Currency Details	
    items: [{
    	xtype: 'form',
    	itemId: 'associateInvoiceCurrencyForm',
    	plugins: "formlabelrequired",
    	standardSubmit: false,
    	items: [{
    		xtype:'panel',
    		width:'100%',
    		itemId: 'associateInvoiceHeaderPanel',
    		items:[{
    			xtype: 'fieldcontainer',
    			layout: {
    				type: 'hbox',
    				width: 256
    			},
    			items: [{
    				xtype: 'hidden',
    				name: 'id',
    				itemId: 'id',
    				hidden:true
    			},{
    				xtype: 'hidden',
    				name: 'receiptId',
    				itemId: 'receiptId',
    				hidden:true
    			},{
    				xtype: 'customcombobox',
    				itemId: 'invoiceCurrency',
    				name: 'invoiceCurrency',
    				width: 256,
    				fieldLabel: getCommonTranslation('INVOICE_CURRENCY'),
    				labelAlign: 'top',
    				store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
    				valueField: 'id',
    				displayField: 'name',
    				forceSelection:true,
    				allowBlank: false,
    				listeners: {
   					 select: function(combo, records, eOpts){
   						 var id = records[0].get('id');
   						 var currencyCode = combo.next();
   						 if(!isNullOrEmpty(currencyCode))  {
   							 currencyCode.setValue(id); 
   						 } 
   						
   					}
   				}
    			},{
    				xtype: 'hidden',
    				itemId: 'invoiceCurrencyCode',
    				name: 'invoiceCurrencyCode',
    			},{
    				xtype: 'multiselectcombofield',
    				itemId: 'receiptCurrency',
    				cls:'receiptHeaderMultiselect',
    				name: 'receiptCurrency',
    				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_CURRENCY'),
    				labelAlign: 'top',
    				width: 536,
    				store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
    				valueField: 'id',
    				displayField: 'name',
    				typeAhead:true,
    				forceSelection:true,
    				allowBlank: false      	  
    			},{
    				xtype: 'button',
    				itemId: 'btnAddAssoInvoiceHeader',
    				cls: 'CustomBodyBtnSettings',
    				style:{'margin-top':'24px !important'},
    				text: getCommonTranslation('ADDBUTTONTEXT'),
    				tooltip: getCommonTranslation('ADD')
    			}] 
    		}]
    	},{
			xtype:'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
    }]
});